{if $error_message}
{literal}
<script>
    document.addEventListener('DOMContentLoaded', function () {
        const messageBox = document.getElementById('content-message-box');
        if (messageBox) {
            const errorMessage = document.createElement('div');
            errorMessage.classList.add('alert', 'alert-danger'); 
            errorMessage.innerHTML = 'Something went wrong. Please try again. Or review the settings';
            messageBox.appendChild(errorMessage);

            setTimeout(function () {
                errorMessage.remove();
            }, 5000);
        }
    });
</script>

{/literal}

{/if}


<div class="card syn-order-sms mt-2">
  <div class="card-header">
    <h3 class="card-header-title">
      SMS {if !empty($sms_history)}({$sms_history|sizeof}){/if}
    </h3>
  </div>
  <div class="card-body">

    <form action="{$link->getAdminLink('AdminSMSNotifications')}" method="post">
      <input type="hidden" name="action" value="send-sms">
      <input type="hidden" name="id_order" value="{$id_order}">

      <label>Επιλέξτε πρώτυπο SMS</label>

      <a id="edit_sms_templates">
        Επεξεργασία πρότυπων
        <img src="/modules/SynSmsnotifications/views/imgs/template.svg">
      </a>
      <select id="select_sms_template" class="custom-select">
        <option value="">-</option>
        {foreach $templates as $template}
          <option value="{$template.id}">{$template.title_sms}</option>
        {/foreach}
      </select>


      <label class="messages"><span class="text-danger">*</span>Τηλέφωνο πελάτη</label>
      <div class="input-group">
        <input type="text" name="sms-phone" class="form-control" value="{$customer_phone}">
      </div>
      <span class="form-description">Η μορφή του τηλεφώνου για Ελλάδα είναι 3069ΧΧΧΧΧΧΧΧ</span>
      {assign var="type" value="order"}
      {include file="module:SynSmsnotifications/views/templates/sms_write_instructions.tpl" type=$type}
     
      <label class="messages"><span class="text-danger">*</span>Μήνυμα</label>
      <div class="input-group js-text-with-length-counter">
        <textarea id="order_sms" name="sms-content" required="required" cols="30" rows="3"
          class="js-countable-input form-control"></textarea>
       
      </div>

      <div style="display:flex;">
      <div id="character_count"></div>
      <div id="character_warning"></div>
    </div>
      <div class="text-right">
        <button type="submit" class="btn btn-primary">Στείλε SMS</button>
      </div>
    </form>


    {if !empty($sms_history)}
      <h4>Ιστορικό SMS</h4>
    {/if}
    {foreach $sms_history as $sms}
      <div class="sms-history">
        <span>{$sms.phone}</span>
        <span class="message">{$sms.message}</span>
        <span>{$sms.date_add}</span>
      </div>
    {/foreach}
  </div>
</div>

<div class="syn-order-sms-filter"></div>
{include file='./sms-templates-popup.tpl' templates=$templates}

<script>
  var syn_sms_notifications_ajax_url = '{$link->getAdminLink('AdminSMSNotifications')}';

  jQuery("#order_sms").on("input", function() {

    var charCount = jQuery(this).val().length;

    var result;

    if (charCount >= 160 && charCount <= 306) {
      result = 2;
    } else if (charCount > 306) {
      result = Math.ceil((charCount - 306) / 156) + 2;
    } else {
      result = 1;
    }

    jQuery("#character_count").html(
      "<strong>" + charCount + "</strong>" + " Χαρακτήρες"
    );

    jQuery("#character_warning").html(
      "Το μήνυμα θα αποσταλεί σε <strong>" + result + " </strong> SMS."
    );

  });
</script>