
$(document).ready(function () {
	
    $('a#edit_sms_templates').click(function () {
		refreshSMSTemplateList();
        $('.syn-order-sms-filter').fadeIn();
        $('.syn-order-sms-popup').fadeIn();
    });
	
    $('.syn-order-sms-filter').click(function () {
        $('.syn-order-sms-filter').fadeOut();
        $('.syn-order-sms-popup').fadeOut();
    });
	
	
	

    function buildSMSTemplateListListeners() {
		
		   $('button.add-sms-template.btn').click(function () {
        $.ajax({
            type: 'POST',
            url: syn_sms_notifications_ajax_url,
            data: {
                ajax: true,
                controller: "AdminSMSNotifications",
                action: "addSMSTemplate",
            },
            success: function (data) {
                jsonData = JSON.parse(data);
                if (jsonData.success) {
                    refreshSMSTemplateList();
                }
            },
            error: function (XMLHttpRequest, textStatus, errorThrown) {
                //jAlert("TECHNICAL ERROR: Details:Error thrown: " + XMLHttpRequest + "" + 'Text status: ' + textStatus);
            }
        });
    });
	
		
		$('#syn_order_sms_close_popup').click(function () {
			$('.syn-order-sms-filter').fadeOut();
			$('.syn-order-sms-popup').fadeOut();
		});
		
        $('.sms-template img.sms-template-edit').click(function () {
            let id_template = $(this).attr('data-template-id');
            $('.sms-template[data-template-id="' + id_template + '"]').toggleClass('edited');
            $('.sms-template-title[data-template-id="' + id_template + '"]').prop('disabled', false);
            $('.sms-template-details[data-template-id="' + id_template + '"]').toggleClass('edited');
        });

        $('img.sms-template-save').click(function () {
            let id_template = $(this).attr('data-template-id');
            let sms_text = $('.sms-template-details[data-template-id="' + id_template + '"] textarea').val();
            let sms_title = $('.sms-template-title[data-template-id="' + id_template + '"]').val();
            $.ajax({
                type: 'POST',
                url: syn_sms_notifications_ajax_url,
                data: {
                    ajax: true,
                    controller: "AdminSMSNotifications",
                    action: "updateSMSTemplate",
                    id_template: id_template,
                    sms_text: sms_text,
                    sms_title: sms_title,
                },
                success: function (data) {
                    jsonData = JSON.parse(data);
                    if (jsonData.success) {
                        $('.sms-template[data-template-id="' + id_template + '"]').toggleClass('edited');
                        $('.sms-template-title[data-template-id="' + id_template + '"]').prop('disabled', true);
                        $('.sms-template-details[data-template-id="' + id_template + '"]').toggleClass('edited');
                    }
                },
                error: function (XMLHttpRequest, textStatus, errorThrown) {
                    //jAlert("TECHNICAL ERROR: Details:Error thrown: " + XMLHttpRequest + "" + 'Text status: ' + textStatus);
                }
            });
        });
		
		$('img.sms-template-delete').click(function () {
            let id_template = $(this).attr('data-template-id');
            $.ajax({
                type: 'POST',
                url: syn_sms_notifications_ajax_url,
                data: {
                    ajax: true,
                    controller: "AdminSMSNotifications",
                    action: "deleteSMSTemplate",
                    id_template: id_template,
                },
                success: function (data) {
                    jsonData = JSON.parse(data);
                    if (jsonData.success) {
                        refreshSMSTemplateList();
                    }
                },
                error: function (XMLHttpRequest, textStatus, errorThrown) {
                    //jAlert("TECHNICAL ERROR: Details:Error thrown: " + XMLHttpRequest + "" + 'Text status: ' + textStatus);
                }
            });
        });
    }

    //first load of the page
    buildSMSTemplateListListeners();

    function refreshSMSTemplateList() {
        $.ajax({
            type: 'POST',
            url: syn_sms_notifications_ajax_url,
            data: {
                ajax: true,
                controller: "AdminSMSNotifications",
                action: "getSMSTemplateList",
            },
            success: function (data) {
                jsonData = JSON.parse(data);

                html = `
                  <button id="syn_order_sms_close_popup"><i class="material-icons">close</i></button>
                  <h3>Πρότυπα SMS</h3>
                  <div class="sms-template-list">`;

                for (var i = 0; i < jsonData.templates.length; i++) {
                    let template = jsonData.templates[i];
                    html += `
                        <div class="sms-template" data-template-id="` + template.id + `">
                          <div class="sms-left-container">
                            <span class="sms-template-id">` + template.id + ` )</span>
                            <input class="sms-template-title" type="text" value="` + template.title_sms + `" disabled
                                   data-template-id="` + template.id + `">
                          </div>
                          <img class="sms-template-edit" src="/modules/SynSmsnotifications/views/imgs/edit.svg"
                               data-template-id="` + template.id + `">
                          <img class="sms-template-save" src="/modules/SynSmsnotifications/views/imgs/save.svg"
                               data-template-id="` + template.id + `">
						  <img class="sms-template-delete" src="/modules/SynSmsnotifications/views/imgs/delete.svg"
                               data-template-id="` + template.id + `">
                        </div>
                        <div class="sms-template-details" data-template-id="` + template.id + `">
                          <label>Μήνυμα</label>
                          <textarea data-template-id=""` + template.id + `">` + template.sms + `</textarea>
                        </div>
                   `;
                }
                html += `
                    <button class="add-sms-template btn btn-primary " >Προσθήκη πρότυπου</button>
                  </div>
                `;

                $('.syn-order-sms-popup').html(html);
                buildSMSTemplateListListeners();
            },
            error: function (XMLHttpRequest, textStatus, errorThrown) {
                //jAlert("TECHNICAL ERROR: Details:Error thrown: " + XMLHttpRequest + "" + 'Text status: ' + textStatus);
            }
        });
    }

    $('button.add-sms-template.btn').click(function () {
        $.ajax({
            type: 'POST',
            url: syn_sms_notifications_ajax_url,
            data: {
                ajax: true,
                controller: "AdminSMSNotifications",
                action: "addSMSTemplate",
            },
            success: function (data) {
                jsonData = JSON.parse(data);
                if (jsonData.success) {
                    refreshSMSTemplateList();
                }
            },
            error: function (XMLHttpRequest, textStatus, errorThrown) {
                //jAlert("TECHNICAL ERROR: Details:Error thrown: " + XMLHttpRequest + "" + 'Text status: ' + textStatus);
            }
        });
    });
	



    $('select#select_sms_template').click(function () {
        let id_template = $(this).val();
        $.ajax({
            type: 'POST',
            url: syn_sms_notifications_ajax_url,
            data: {
                ajax: true,
                controller: "AdminSMSNotifications",
                action: "getSMSTemplateContent",
                id_template: id_template
            },
            success: function (data) {
                jsonData = JSON.parse(data);
                $('textarea#order_sms').html(jsonData.sms)
            },
            error: function (XMLHttpRequest, textStatus, errorThrown) {
                //jAlert("TECHNICAL ERROR: Details:Error thrown: " + XMLHttpRequest + "" + 'Text status: ' + textStatus);
            }
        });
    });
});
