<?php

class AdminSMSNotificationsController extends ModuleAdminController
{
    public function initContent()
    {

        $action = Tools::getValue("action");
        $id_order = Tools::getValue("id_order");
        $callback = Context::getContext()->shop->getBaseURL(true) . "modules/SynSmsnotifications/callback.php";

        $sender_id = Configuration::get("SYN_SMS_NOTIFICATIONS_SENDER_ID");
        $api_key = Configuration::get("SYN_SMS_NOTIFICATIONS_API_TOKEN");
        $api_secret = Configuration::get("SYN_SMS_NOTIFICATIONS_API_SECRET");

        $routing_option = Configuration::get("SYN_SMS_NOTIFICATIONS_ROUTING_OPTION");

        if ($id_order != '' && !empty($id_order)) {

            switch ($action) {

                case "send-sms":
                    try {
                        $customer_phone = Tools::getValue("sms-phone");
                        // ADD +30 IF IT DOES NOT EXIST TO THE MOBILE NUMBER
                        if (substr($customer_phone, 0, 3) !== '+30' && substr($customer_phone, 0, 2) !== '30') {
                            $customer_phone = '30' . $customer_phone;
                        }

                        $sms_message_raw = Tools::getValue("sms-content");
                        $id_customer = Db::getInstance()->getValue("select id_customer from " . _DB_PREFIX_ . "orders where id_order = '$id_order'");

                        $order_obj = new Order($id_order);

                        $customer = new Customer($order_obj->id_customer);
                        $first_name = $customer->firstname;
                        $last_name = $customer->lastname;

                        $order_total = Tools::displayPrice($order_obj->total_paid, Currency::getCurrencyInstance($order_obj->id_currency));

                        $placeholders = array("{first_name}", "{last_name}", "{order_id}", "{order_total}", "{shipping_number}");

                        $values = array($first_name, $last_name, $id_order, $order_total, $order_obj->shipping_number);

                        $sms_message_raw = str_replace($placeholders, $values, $sms_message_raw);

                        $sms_message = $sms_message_raw;


                        if ($routing_option == 'sms') {
                            $params = array(
                                'priority' => 3,
                                'recipients' => array(
                                    array('msisdn' => $customer_phone)
                                ),
                                'sms' => array(
                                    'sender' => $sender_id,
                                    'text' => $sms_message,
                                    'encoding' => 'gsm',
                                    'validityPeriod' => 86400
                                ),
                                'dlr' => true,
                                'dlrUrl' => $callback,
                                'externalTags' => array('string')
                            );
                        } else if ($routing_option == 'viber') {
                            $params = array(
                                'routing' => 'viberTransactional',
                                'priority' => 3,
                                'recipients' => array(
                                    array('msisdn' => $customer_phone)
                                ),
                                'viber' => array(
                                    'sender' => $sender_id,
                                    'type' => 'text',
                                    'text' => $sms_message,
                                    'encoding' => 'gsm',
                                    'validityPeriod' => 86400
                                ),
                                'dlr' => true,
                                'dlrUrl' => $callback,
                                'externalTags' => array('string')
                            );
                        } else if ($routing_option == 'viber2sms') {
                            $params = array(
                                'routing' => 'viberTransactional2SMS',
                                'priority' => 3,
                                'recipients' => array(
                                    array('msisdn' => $customer_phone)
                                ),
                                'viber' => array(
                                    'sender' => $sender_id,
                                    'type' => 'text',
                                    'text' => $sms_message,
                                    'encoding' => 'gsm',
                                    'validityPeriod' => 86400
                                ),
                                'sms' => array(
                                    'sender' => $sender_id,
                                    'text' => $sms_message,
                                    'encoding' => 'gsm',
                                    'validityPeriod' => 86400
                                ),
                                'dlr' => true,
                                'dlrUrl' => $callback,
                                'externalTags' => array('string')
                            );
                        }
                        $encoded_params = json_encode($params, JSON_UNESCAPED_UNICODE);

                        $todayNumber = date('N');
                        $inDays = Db::getInstance()->getValue("select days from modulus_time_rule where active = 1");
                        $currentTimeWithoutSeconds = date('H:i');
                        $timefrom = Db::getInstance()->getValue("select timefrom from modulus_time_rule");
                        $timeto = Db::getInstance()->getValue("select timeto from modulus_time_rule");

                        if (!empty($inDays)) {
                            if (strpos($inDays, $todayNumber) !== false && ($currentTimeWithoutSeconds >= $timefrom && $currentTimeWithoutSeconds <= $timeto)) {
                                $res = $this->sms_send($encoded_params, $customer_phone, $sms_message);
                            } else {
                                Db::getInstance()->execute("insert into modulus_pending_message (phone_number,message,is_sent) values ('$customer_phone','$sms_message','0')");
                            }
                        } else {
                            $res = $this->sms_send($encoded_params, $customer_phone, $sms_message);
                        }

                        $http_code = $res['http_status'];

                        // record repsonse
                        $curl_response = $res['decoded_resp'];

                        $msg = $curl_response['message'];

                        $employee_id = $this->context->employee->id;

                        Db::getInstance()->execute("INSERT INTO `syn_order_sms`( `id_order`, `id_customer`,  `id_employee`, `message`, `response`, `phone`, `date_add`) 
						VALUES ($id_order, $id_customer, $employee_id, '$sms_message_raw', '$msg', '$customer_phone', NOW())");
                    } catch (Exception $e) {
                        // Handle and log the exception
//                        error_log("Error sending SMS: " . $e->getMessage());
                        $order_url = str_replace('/orders/', '/orders/' . $id_order . '/view', $this->context->link->getAdminLink('AdminOrders') . "&error=1");
                        Tools::redirectAdmin($order_url);
                    }

                    break;
            }

            $order_url = str_replace('/orders/', '/orders/' . $id_order . '/view', $this->context->link->getAdminLink('AdminOrders'));
            Tools::redirectAdmin($order_url);

        } else {
            try {
                $id_customer = Tools::getValue("id_customer");
                $customer_phone = Tools::getValue("sms-phone");
                $sms_message_raw = Tools::getValue("sms-content");
                if (substr($customer_phone, 0, 3) !== '+30' && substr($customer_phone, 0, 2) !== '30') {
                    $customer_phone = '30' . $customer_phone;
                }


                $customer = new Customer($id_customer);
                $first_name = $customer->firstname;
                $last_name = $customer->lastname;

                $placeholders = array("{first_name}", "{last_name}");

                $values = array($first_name, $last_name);

                $sms_message = str_replace($placeholders, $values, $sms_message_raw);

                if ($routing_option == 'sms') {
                    $params = array(
                        'priority' => 3,
                        'recipients' => array(
                            array('msisdn' => $customer_phone)
                        ),
                        'sms' => array(
                            'sender' => $sender_id,
                            'text' => $sms_message,
                            'encoding' => 'gsm',
                            'validityPeriod' => 86400
                        ),
                        'dlr' => true,
                        'dlrUrl' => $callback,
                        'externalTags' => array('string')
                    );
                } else if ($routing_option == 'viber') {
                    $params = array(
                        'routing' => 'viberTransactional',
                        'priority' => 3,
                        'recipients' => array(
                            array('msisdn' => $customer_phone)
                        ),
                        'viber' => array(
                            'sender' => $sender_id,
                            'type' => 'text',
                            'text' => $sms_message,
                            'encoding' => 'gsm',
                            'validityPeriod' => 86400
                        ),
                        'dlr' => true,
                        'dlrUrl' => $callback,
                        'externalTags' => array('string')
                    );
                } else if ($routing_option == 'viber2sms') {
                    $params = array(
                        'routing' => 'viberTransactional2SMS',
                        'priority' => 3,
                        'recipients' => array(
                            array('msisdn' => $customer_phone)
                        ),
                        'viber' => array(
                            'sender' => $sender_id,
                            'type' => 'text',
                            'text' => $sms_message,
                            'encoding' => 'gsm',
                            'validityPeriod' => 86400
                        ),
                        'sms' => array(
                            'sender' => $sender_id,
                            'text' => $sms_message,
                            'encoding' => 'gsm',
                            'validityPeriod' => 86400
                        ),
                        'dlr' => true,
                        'dlrUrl' => $callback,
                        'externalTags' => array('string')
                    );
                }
                $encoded_params = json_encode($params, JSON_UNESCAPED_UNICODE);
                $todayNumber = date('N');
                $inDays = Db::getInstance()->getValue("select days from modulus_time_rule where active = 1");
                $currentTimeWithoutSeconds = date('H:i');
                $timefrom = Db::getInstance()->getValue("select timefrom from modulus_time_rule");
                $timeto = Db::getInstance()->getValue("select timeto from modulus_time_rule");
                if (!empty($inDays)) {
                    if (strpos($inDays, $todayNumber) !== false && ($currentTimeWithoutSeconds >= $timefrom && $currentTimeWithoutSeconds <= $timeto)) {
                        $res = $this->sms_send($encoded_params, $customer_phone, $sms_message);
                    } else {
                        if (!empty($customer_phone)) {
                            Db::getInstance()->execute("insert into modulus_pending_message (phone_number,message,is_sent) values ('$customer_phone','$sms_message','0')");

                        }
                    }
                } else {
                    $res = $this->sms_send($encoded_params, $customer_phone, $sms_message);
                }

                $curl_response = $res['decoded_resp'];


                $employee_id = $this->context->employee->id;

                $msg = $curl_response['messages'][0]['status']['message'];
//                error_log(print_r($res));

                Db::getInstance()->execute("INSERT INTO `syn_order_sms`( `id_customer`,  `id_employee`, `message`, `response`, `phone`, `date_add`) VALUES ($id_customer, $employee_id, '$sms_message_raw', '$msg', '$customer_phone', NOW())");

            } catch (Exception $e) {
                $customer_url = str_replace('/customers/', '/customers/' . $id_customer . '/view', $this->context->link->getAdminLink('AdminCustomers') . "&error=1");
                Tools::redirectAdmin($customer_url);
            }
            $customer_url = str_replace('/customers/', '/customers/' . $id_customer . '/view', $this->context->link->getAdminLink('AdminCustomers'));
            Tools::redirectAdmin($customer_url);
        }


    }

    public function ajaxProcessUpdateSMSTemplate()
    {
        $id_template = Tools::getValue("id_template");
        $sms_text = Tools::getValue("sms_text");
        $sms_title = Tools::getValue("sms_title");

        $sql = "UPDATE syn_smstemplates SET sms = '$sms_text',title_sms = '$sms_title' WHERE id = $id_template";

        echo json_encode(
            array(
                "success" => Db::getInstance()->execute($sql)
            )
        );
        die();
    }

    public function ajaxProcessGetSMSTemplateList()
    {

        echo json_encode(
            array(
                "templates" => Db::getInstance()->executeS("SELECT * FROM syn_smstemplates"),
            )
        );
        die();
    }

    public function ajaxProcessAddSMSTemplate()
    {
        $sql = "INSERT INTO `syn_smstemplates`(`sms`, `creation_date`, `title_sms`) VALUES ('',NOW(),'')";
        echo json_encode(
            array(
                "success" => Db::getInstance()->execute($sql)
            )
        );
        die();
    }

    public function ajaxProcessGetSMSTemplateContent()
    {

        $id_template = Tools::getValue("id_template");

        $sql = "SELECT sms FROM `syn_smstemplates` WHERE id=$id_template";

        echo json_encode(
            array(
                "sms" => Db::getInstance()->getValue($sql)
            )
        );
        die();
    }

    public function ajaxProccesssubmitSMSFormm()
    {
        $sms = Tools::getValue('create_sms');
        $sms_text = Tools::getValue('create_sms_text');
        $id_lang = Tools::getValue('id_language');
        $id_langint = Db::getInstance()->getValue("select id_lang from  " . _DB_PREFIX_ . "lang where iso_code = '$id_lang'");
        $todayDate = date("Y-m-d H:i:s");

        Db::getInstance()->execute("insert into syn_smstemplates (sms,creation_date,last_edit_date,title_sms,id_lang) values ('$sms_text','$todayDate','$todayDate','$sms','$id_langint')");

    }

    public function ajaxProcessDeleteSMSTemplate()
    {
        $id_template = Tools::getValue("id_template");

        $sql = "DELETE FROM syn_smstemplates WHERE id = $id_template";

        echo json_encode(
            array(
                "success" => Db::getInstance()->execute($sql)
            )
        );
        die();
    }

    public function sms_send($params, $customer_phone, $sms_message, $backup = false)
    {


        $api_key = Configuration::get("SYN_SMS_NOTIFICATIONS_API_TOKEN");

        $api_url = Configuration::get("SYN_SMS_NOTIFICATIONS_API_URL");


        $curl = curl_init();

        curl_setopt_array(
            $curl,
            array(
                CURLOPT_URL => "$api_url",
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'POST',
                CURLOPT_POSTFIELDS => $params,
                CURLOPT_HTTPHEADER => array(
                    'Authorization: Bearer ' . $api_key,
                    'Content-Type: application/json'
                ),
            )
        );

        $response = curl_exec($curl);

        $http_status = curl_getinfo($curl, CURLINFO_HTTP_CODE);

        $response_decoded = json_decode($response, true);

        $messageId = $response_decoded['messages'][0]['messageId'];

        $code = $response_decoded['messages'][0]['status']['code'];

        $message = $response_decoded['messages'][0]['status']['message'];

        Db::getInstance()->execute("insert into modulus_logs (messageId,code,message,msisdn,message_text) values ('$messageId','$code','$message','$customer_phone','$sms_message')");

        curl_close($curl);
//        error_log(print_r($response));

        return array('message' => $message, 'http_status' => $response);

    }

}