<?php


if (!defined('_PS_VERSION_'))
    exit;


class SynSmsnotifications extends Module
{
    public function __construct()
    {
        $this->name = 'SynSmsnotifications';
        $this->tab = 'administration';
        $this->version = '1.4';
        $this->author = 'modulus';
        $this->bootstrap = true;

        parent::__construct();

        $this->displayName = $this->l('modulus Messaging Platform');
        $this->description = $this->l('Δυνατότητα αποστολής SMS και Viber μηνυμάτων στους πελάτες σας, μεσω του modulus Messaging Platform.');
        $this->installSQL();
        $this->createTab();
    }


    public function createTab()
    {

        // Check if the tab already exists
        $tabExists = Db::getInstance()->getValue('
        SELECT COUNT(*) 
        FROM ' . _DB_PREFIX_ . 'tab 
        WHERE `class_name` = "AdminSMSNotifications"
    ');

        // If the tab already exists, skip creation
        if ($tabExists) {
            // Optionally update the module name if needed
            $sql = 'UPDATE ' . _DB_PREFIX_ . 'tab 
                SET `module` = "SynSmsnotifications" 
                WHERE `class_name` = "AdminSMSNotifications"';
            Db::getInstance()->execute($sql);
            return true; // Tab exists, no need to create it again
        }

        // Create the new Tab object since it doesn't exist
        $tab = new Tab();
        $tab->class_name = 'AdminSMSNotifications'; // Your controller name
        $tab->module = $this->name; // Use $this->name dynamically here
        $tab->id_parent = 0; // Set parent if needed

        $tab->name = [];
        foreach (Language::getLanguages(true) as $lang) {
            $tab->name[$lang['id_lang']] = 'SMS Notifications';
        }

        if ($tab->add()) {

            $sql = 'UPDATE ' . _DB_PREFIX_ . 'tab 
                SET `module` = "SynSmsnotifications" 
                WHERE `class_name` = "AdminSMSNotifications"';

            // Execute the update query
            Db::getInstance()->execute($sql);
            return true; // Tab was created successfully
        } else {
            // Handle error if the tab could not be added
            PrestaShopLogger::addLog('Failed to create AdminSMSNotifications tab', 3);
            return false;
        }
    }

    public function install()
{
    if (!parent::install()) {
        return false;
    }

    if (version_compare(_PS_VERSION_, '8.0.0', '<')) {
        $this->registerHook('displayAdminOrder');
    } else {
        $this->registerHook('displayAdminOrderSideBottom');
    }

    return $this->registerHook('displayBackOfficeHeader') &&
        $this->registerHook('displayAdminCustomers') &&
        $this->registerHook('displayBackInStock') &&
        $this->registerHook('actionUpdateQuantity') &&
        $this->registerHook('displayProductAdditionalInfo') &&
        $this->registerHook('actionOrderStatusPostUpdate') &&
        $this->registerHook('actionProductAttributeUpdate');
}

public function uninstall()
{
    if (version_compare(_PS_VERSION_, '8.0.0', '<')) {
        $this->unregisterHook('displayAdminOrder');
    } else {
        $this->unregisterHook('displayAdminOrderSideBottom');
    }

    return parent::uninstall() &&
        $this->unregisterHook('displayBackOfficeHeader') &&
        $this->unregisterHook('displayAdminCustomers') &&
        $this->unregisterHook('displayBackInStock') &&
        $this->unregisterHook('actionUpdateQuantity') &&
        $this->unregisterHook('displayProductAdditionalInfo') &&
        $this->unregisterHook('actionOrderStatusPostUpdate') &&
        $this->unregisterHook('actionProductAttributeUpdate');
}

	public function installSQL()
    {
        // $return = true;
        // BACK IN STOCK TABLE
        return (
            Db::getInstance()->execute('CREATE TABLE IF NOT EXISTS modulus_sms_back_in_stock_template(
			id INT NOT NULL AUTO_INCREMENT,
			title TEXT NOT NULL,
			message TEXT NOT NULL,
			language VARCHAR(255) NOT NULL,
			creation_date TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
			last_edit_date TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
			PRIMARY KEY (id)
			) ENGINE=' . _MYSQL_ENGINE_ . '  DEFAULT CHARACTER SET utf8 DEFAULT COLLATE utf8_general_ci') &&

            // BACK IN STOCK TABLE CREATE
            Db::getInstance()->execute('CREATE TABLE IF NOT EXISTS modulus_back_in_stock(
			id INT NOT NULL AUTO_INCREMENT,
			product_id int(11) NOT NULL,
			id_product_attribute int(11) NOT NULL,
			phone_number text NOT NULL,
			id_lang int(11) NOT NULL,
			notify_id int(11) NOT NULL,
			PRIMARY KEY (id)
			) ENGINE=' . _MYSQL_ENGINE_ . '  DEFAULT CHARACTER SET utf8 DEFAULT COLLATE utf8_general_ci') &&

            // MODULUS LOGS CREATE TABLE
            Db::getInstance()->execute('CREATE TABLE IF NOT EXISTS modulus_logs(
			messageId VARCHAR(255) NOT NULL,
			code text NULL,
			message text NULL ,
			msisdn text NOT NULL,
			message_text text NULL,
			deliveryReportAt text NULL,
			PRIMARY KEY (messageId)
			) ENGINE=' . _MYSQL_ENGINE_ . '  DEFAULT CHARACTER SET utf8 DEFAULT COLLATE utf8_general_ci') &&

            // modulus_pending_message CREATE TABLE
            Db::getInstance()->execute('CREATE TABLE IF NOT EXISTS modulus_pending_message(
			id INT NOT NULL AUTO_INCREMENT,
			phone_number text NOT NULL,
			message text NULL ,
			is_sent int(11),
			PRIMARY KEY (id)
			) ENGINE=' . _MYSQL_ENGINE_ . '  DEFAULT CHARACTER SET utf8 DEFAULT COLLATE utf8_general_ci') &&

            // syn_order_sms CREATE TABLE
            Db::getInstance()->execute('CREATE TABLE IF NOT EXISTS syn_order_sms(
			`id` int(11) NOT NULL AUTO_INCREMENT,
			`id_customer` int(11) DEFAULT NULL,
			`id_order` int(11) DEFAULT NULL,
			`id_employee` int(11) DEFAULT NULL,
			`message` text DEFAULT NULL,
			`response` text DEFAULT NULL,
			`phone` varchar(20) DEFAULT NULL,
			`date_add` datetime DEFAULT NULL,
			PRIMARY KEY (`id`),
			KEY `id_order` (`id_order`)
			) ENGINE=' . _MYSQL_ENGINE_ . '  DEFAULT CHARACTER SET utf8 DEFAULT COLLATE utf8_general_ci') &&

            // syn_smsordertemplates CREATE TABLE
            Db::getInstance()->execute('CREATE TABLE IF NOT EXISTS syn_smsordertemplates(
			`id` int(11) NOT NULL AUTO_INCREMENT,
			`id_template` int(11) NOT NULL,
			`id_order_status` int(11) NOT NULL,
			`id_lang` int(11) NOT NULL,
			`create_date` datetime NOT NULL,
			`update_date` datetime NOT NULL,
			`active` int(11) NOT NULL,
			PRIMARY KEY (`id`)
			) ENGINE=' . _MYSQL_ENGINE_ . '  DEFAULT CHARACTER SET utf8 DEFAULT COLLATE utf8_general_ci') &&

            // syn_smstemplates CREATE TABLE
            Db::getInstance()->execute('CREATE TABLE IF NOT EXISTS syn_smstemplates(
			`id` int(11) NOT NULL AUTO_INCREMENT,
			`sms` text DEFAULT NULL,
			`creation_date` datetime DEFAULT NULL,
			`last_edit_date` datetime NOT NULL DEFAULT current_timestamp(),
			`title_sms` varchar(100) DEFAULT NULL,
			`id_lang` int(11) NOT NULL,
			PRIMARY KEY (`id`)
			) ENGINE=' . _MYSQL_ENGINE_ . '  DEFAULT CHARACTER SET utf8 DEFAULT COLLATE utf8_general_ci') &&

            // modulus_time_rule CREATE TABLE
            Db::getInstance()->execute('CREATE TABLE IF NOT EXISTS modulus_time_rule (
			`id_rule` int(11) NOT NULL AUTO_INCREMENT,
			`days` text NOT NULL,
			`timefrom` text NOT NULL,
			`timeto` text NOT NULL,
			`active` int(11) NOT NULL,
			PRIMARY KEY (`id_rule`)
			) ENGINE=' . _MYSQL_ENGINE_ . '  DEFAULT CHARACTER SET utf8 DEFAULT COLLATE utf8_general_ci')

        );

    }


    public function getSMSHistory($id_order)
    {
        return Db::getInstance()->executeS("SELECT * FROM syn_order_sms WHERE id_order = $id_order");
    }

    public function getSMSHistoryCust($id_customer)
    {
        return Db::getInstance()->executeS("SELECT * FROM syn_order_sms WHERE id_customer = $id_customer");
    }

    public function getSMSTemplates($idLang)
    {
        if ($idLang == null) {
            return Db::getInstance()->executeS("SELECT * FROM syn_smstemplates ");

        } else {
            return Db::getInstance()->executeS("SELECT * FROM syn_smstemplates where id_lang = '$idLang'");

        }
    }

    public function getSMSTemplatesAll()
    {
        return Db::getInstance()->executeS("SELECT * FROM syn_smstemplates");
    }

    public function hookDisplayBackInStock($params)
    {

    }


    public function hookDisplayProductAdditionalInfo($params)
    {
		
        if ($params['product']['minimal_quantity'] <= $params['product']['quantity'] || Product::isAvailableWhenOutOfStock($params['product']['out_of_stock'])) {
            return;
        }

        $id_product = (int)$params['product']['id'];
        $id_product_attribute = $params['product']['id_product_attribute'];
        $id_lang = $this->context->language->id;

        $this->context->smarty->assign('csrf', Tools::encrypt("SynSmsnotifications"));
        $this->context->smarty->assign('id_product', $id_product);
        $this->context->smarty->assign('id_product_attribute', $id_product_attribute);
        $this->context->smarty->assign('id_lang', $id_lang);

        if (Tools::isSubmit('submitNotify')) {
            $phone_number = Tools::getValue('tel_back_in_stock');

            $exist = Db::getInstance()->getValue("select product_id from modulus_back_in_stock where product_id = '$idProduct' and phone_number = '$phone_number'");
            if (empty($exist)) {

                Db::getInstance()->execute("insert into modulus_back_in_stock (product_id,id_product_attribute,phone_number,id_lang,notify_id) values ('$idProduct','$idProductAttr','$phone_number','$id_lang','0')");
            }
        }


        if (Configuration::get("SYN_BACK_IN_STOCK_STATUS") == 'on') {
            return $this->display(__FILE__, 'views/templates/sms-backinstock.tpl');
        }

    }

    public function sendAllMessages()
    {
        $sqlselector = Db::getInstance()->executeS("select * from modulus_back_in_stock where notify_id = 0");


        foreach ($sqlselector as $res) {
            $id_product = $res['product_id'];
            $id_product_attribute = $res['id_product_attribute'];
            $phone_number = $res['phone_number'];
            $id_lang = $res['id_lang'];
            $phone_numberstart = $phone_number;
            $sturl = $_SERVER['REQUEST_URI'];
            $domain = Tools::getShopDomain(true);

            $callback = Context::getContext()->shop->getBaseURL(true) . "modules/SynSmsnotifications/callback.php";

            $quantity = Db::getInstance()->getValue("select quantity from " . _DB_PREFIX_ . "stock_available where id_product = '$id_product' and id_product_attribute = '$id_product_attribute'");

            if ($quantity > 0) {

                if ($id_lang == 1) {

                    $productName = Db::getInstance()->getValue("select name from  " . _DB_PREFIX_ . "product_lang where id_product = '$id_product' and id_lang = 1");
                    $attrName = Db::getInstance()->getValue("select id_attribute from  " . _DB_PREFIX_ . "product_attribute_combination where id_product_attribute = '$id_product_attribute'");
                    $attrNameStr = Db::getInstance()->getValue("select name from  " . _DB_PREFIX_ . "attribute_lang where id_attribute = '$attrName' and id_lang = 1");

                    $attrGroup = Db::getInstance()->getValue("select id_attribute_group from  " . _DB_PREFIX_ . "attribute where id_attribute = '$attrName'");
                    $attrGroupName = Db::getInstance()->getValue("select name from  " . _DB_PREFIX_ . "attribute_group_lang where id_attribute_group = '$attrGroup' and id_lang = 1");

                    $productName = $productName . ' ' . $attrGroupName . ' ' . $attrNameStr;
                    $prod_url = Context::getContext()->link->getProductLink($id_product);
                    $text_template = Db::getInstance()->getValue("select message from modulus_sms_back_in_stock_template language = 1");

                    $placeholders = array("{product_name}", "{product_url}");
                    $values = array($productName, $prod_url);
                    $smsreplace = str_replace($placeholders, $values, $text_template);

                    $text = $smsreplace;

                } elseif ($id_lang == 2) {

                    $productName = Db::geInstance()->getValue("select name from  " . _DB_PREFIX_ . "product_lang where id_product = '$id_product' and id_lang = 2");
                    $attrName = Db::getInstance()->getValue("select id_attribute from  " . _DB_PREFIX_ . "product_attribute_combination where id_product_attribute = '$id_product_attribute'");
                    $attrNameStr = Db::getInstance()->getValue("select name from  " . _DB_PREFIX_ . "attribute_lang where id_attribute = '$attrName' and id_lang = 2");

                    $attrGroup = Db::getInstance()->getValue("select id_attribute_group from  " . _DB_PREFIX_ . "attribute where id_attribute = '$attrName'");
                    $attrGroupName = Db::getInstance()->getValue("select name from  " . _DB_PREFIX_ . "attribute_group_lang where id_attribute_group = '$attrGroup' and id_lang = 2");

                    $productName = $productName . ' ' . $attrGroupName . ' ' . $attrNameStr;

                    $text_template = Db::getInstance()->getValue("select message from modulus_sms_back_in_stock_template language = 2");

                    $placeholders = array("{product_name}", "{product_url}");

                    $values = array($productName, $prod_url);

                    $smsreplace = str_replace($placeholders, $values, $text_template);

                    $text = $smsreplace;

                }


                $phone_number = '30' . $phone_numberstart;
                $todayNumber = date('N');
                $inDays = Db::getInstance()->getValue("select days from modulus_time_rule where active = 1");
                $currentTimeWithoutSeconds = date('H:i');
                $timefrom = Db::getInstance()->getValue("select timefrom from modulus_time_rule");
                $timeto = Db::getInstance()->getValue("select timeto from modulus_time_rule");


                $sender_id = Tools::getValue("SYN_SMS_NOTIFICATIONS_SENDER_ID");
                $api_token = Tools::getValue("SYN_SMS_NOTIFICATIONS_API_TOKEN");
                $api_secret = Tools::getValue("SYN_SMS_NOTIFICATIONS_API_SECRET");

                if (!empty($inDays)) {
                    if (strpos($inDays, $todayNumber) !== false && ($currentTimeWithoutSeconds >= $timefrom && $currentTimeWithoutSeconds <= $timeto)) {
                        $curl = curl_init();

                        curl_setopt_array(
                            $curl,
                            array(
                                CURLOPT_URL => 'https://messaging.modulus.gr/ott-api/message',
                                CURLOPT_RETURNTRANSFER => true,
                                CURLOPT_ENCODING => '',
                                CURLOPT_MAXREDIRS => 10,
                                CURLOPT_TIMEOUT => 0,
                                CURLOPT_FOLLOWLOCATION => true,
                                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                                CURLOPT_CUSTOMREQUEST => 'POST',
                                CURLOPT_POSTFIELDS => '{

							  "priority": 3,
							  "recipients": [
								{
								  "msisdn": "' . $phone_number . '"
								}
							  ],

							  "sms": {
								"sender": "' . $sender_id . '",
								"text": "' . $text . '",
								"encoding": "gsm",
								"validityPeriod": 86400

							  },
							  "dlr": true,
							  "dlrUrl": "' . $callback . '",
							  "externalTags": [
								"string"
							  ]
							}',
                                CURLOPT_HTTPHEADER => array(
                                    'Authorization: Bearer ' . $api_token,
                                    'Content-Type: application/json'
                                ),
                            )
                        );

                        $response = curl_exec($curl);
                        $response = json_decode($response, true);
                        $messageId = $response['messages'][0]['messageId'];
                        $code = $response['messages'][0]['status']['code'];
                        $message = $response['messages'][0]['status']['message'];
                        Db::getInstance()->execute("insert into modulus_logs (messageId,code,message,msisdn,message_text) values ('$messageId','$code','$message','$phone_number','$text')");
                        Db::getInstance()->execute("update modulus_back_in_stock set notify_id = 1 where phone_number = '$phone_numberstart' and product_id = '$id_product'");

                        curl_close($curl);

                    } else {
                        Db::getInstance()->execute("insert into modulus_pending_message (phone_number,message,is_sent) values ('$phone_number','$text','0')");
                    }
                } else {
                    $curl = curl_init();

                    curl_setopt_array(
                        $curl,
                        array(
                            CURLOPT_URL => 'https://messaging.modulus.gr/ott-api/message',
                            CURLOPT_RETURNTRANSFER => true,
                            CURLOPT_ENCODING => '',
                            CURLOPT_MAXREDIRS => 10,
                            CURLOPT_TIMEOUT => 0,
                            CURLOPT_FOLLOWLOCATION => true,
                            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                            CURLOPT_CUSTOMREQUEST => 'POST',
                            CURLOPT_POSTFIELDS => '{

							  "priority": 3,
							  "recipients": [
								{
								  "msisdn": "' . $phone_number . '"
								}
							  ],

							  "sms": {
								"sender": "Synergic",
								"text": "' . $text . '",
								"encoding": "gsm",
								"validityPeriod": 86400

							  },
							  "dlr": true,
							  "dlrUrl": "' . $callback . '",
							  "externalTags": [
								"string"
							  ]
							}',
                            CURLOPT_HTTPHEADER => array(
                                'Authorization: Bearer 2G8bUFN3ud4CWd64Y6CFCaCjWyL13lxd2OUpsEuLDeKPOzDpghiNGH9DgNUpH29V',
                                'Content-Type: application/json'
                            ),
                        )
                    );

                    $response = curl_exec($curl);
                    $response = json_decode($response, true);
                    $messageId = $response['messages'][0]['messageId'];
                    $code = $response['messages'][0]['status']['code'];
                    $message = $response['messages'][0]['status']['message'];
                    Db::getInstance()->execute("insert into modulus_logs (messageId,code,message,msisdn,message_text) values ('$messageId','$code','$message','$phone_number','$text')");
                    Db::getInstance()->execute("update modulus_back_in_stock set notify_id = 1 where phone_number = '$phone_numberstart' and product_id = '$id_product'");

                    curl_close($curl);
                }

            }

        }
    }

    public function sendAllTimedMessages()
    {
        $callback = Context::getContext()->shop->getBaseURL(true) . "modules/SynSmsnotifications/callback.php";
        $routing_option = Configuration::get("SYN_SMS_NOTIFICATIONS_ROUTING_OPTION");

        $sender_id = Configuration::get("SYN_SMS_NOTIFICATIONS_SENDER_ID");
        $api_key = Configuration::get("SYN_SMS_NOTIFICATIONS_API_TOKEN");
        $api_url = Configuration::get("SYN_SMS_NOTIFICATIONS_API_URL");
        $todayNumber = date('N');
        $inDays = Db::getInstance()->getValue("select days from modulus_time_rule");
        $currentTimeWithoutSeconds = date('H:i');
        $timefrom = Db::getInstance()->getValue("select timefrom from modulus_time_rule");
        $timeto = Db::getInstance()->getValue("select timeto from modulus_time_rule");
        if ((strpos($inDays, $todayNumber) !== false && ($currentTimeWithoutSeconds >= $timefrom && $currentTimeWithoutSeconds <= $timeto)) || ($inDays == '' && $timefrom == '' && $timeto == '')) {
            $sqlselector = Db::getInstance()->executeS("select * from modulus_pending_message where is_sent = 0 order by phone_number asc limit 10");

            foreach ($sqlselector as $res) {

                $phone_number = $res['phone_number'];
                $message = $res['message'];
                $id = $res['id'];

                if ($routing_option == 'sms') {

                    $curl = curl_init();

                    curl_setopt_array(
                        $curl,
                        array(
                            CURLOPT_URL => "$api_url",
                            CURLOPT_RETURNTRANSFER => true,
                            CURLOPT_ENCODING => '',
                            CURLOPT_POST => 1,
                            CURLOPT_MAXREDIRS => 10,
                            CURLOPT_TIMEOUT => 0,
                            CURLOPT_FOLLOWLOCATION => true,
                            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                            CURLOPT_CUSTOMREQUEST => 'POST',
                            CURLOPT_POSTFIELDS => '{
				
							"priority": 3,
							"recipients": [
							{
							"msisdn": "' . $phone_number . '"
							}
							],
							
							"sms": {
							"sender": "' . $sender_id . '",
							"text": "' . $message . '",
							"encoding": "gsm",
							"validityPeriod": 86400
							
							},
							"dlr": true,
							"dlrUrl": "' . $callback . '",
							"externalTags": [
							"string"
							]
							}',
                            CURLOPT_HTTPHEADER => array(
                                'Authorization: Bearer ' . $api_key,
                                'Content-Type: application/json'
                            ),

                        )
                    );
                } else if ($routing_option == 'viber') {
                    $curl = curl_init();

                    curl_setopt_array(
                        $curl,
                        array(
                            CURLOPT_URL => "$api_url",
                            CURLOPT_RETURNTRANSFER => true,
                            CURLOPT_ENCODING => '',
                            CURLOPT_POST => 1,
                            CURLOPT_MAXREDIRS => 10,
                            CURLOPT_TIMEOUT => 0,
                            CURLOPT_FOLLOWLOCATION => true,
                            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                            CURLOPT_CUSTOMREQUEST => 'POST',
                            CURLOPT_POSTFIELDS => '{
				
							"routing": "viberTransactional",
							"priority": 3,
							"recipients": [
							{
							"msisdn": "' . $phone_number . '"
							}
							],
							"viber": {
							"sender": "' . $sender_id . '",
							"type": "text",
							"validityPeriod": 86400,
							"text": "' . $message . '",
							"encoding": "gsm"
							
							},
							
							"dlr": true,
							"dlrUrl": "' . $callback . '",
							"externalTags": [
							"string"
							]
							}',
                            CURLOPT_HTTPHEADER => array(
                                'Authorization: Bearer ' . $api_key,
                                'Content-Type: application/json'
                            ),

                        )
                    );
                } else if ($routing_option == 'viber2sms') {
                    $curl = curl_init();

                    curl_setopt_array(
                        $curl,
                        array(
                            CURLOPT_URL => "$api_url",
                            CURLOPT_RETURNTRANSFER => true,
                            CURLOPT_ENCODING => '',
                            CURLOPT_POST => 1,
                            CURLOPT_MAXREDIRS => 10,
                            CURLOPT_TIMEOUT => 0,
                            CURLOPT_FOLLOWLOCATION => true,
                            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                            CURLOPT_CUSTOMREQUEST => 'POST',
                            CURLOPT_POSTFIELDS => '{
				
							"routing": "viberTransactional2SMS",
							"priority": 3,
							"recipients": [
							{
							"msisdn": "' . $phone_number . '"
							}
							],
							"viber": {
							"sender": "' . $sender_id . '",
							"type": "text",
							"validityPeriod": 86400,
							"text": "' . $message . '",
							"encoding": "gsm"
							
							},
							"sms": {
							"sender": "' . $sender_id . '",
							"text": "' . $message . '",
							"encoding": "gsm",
							"validityPeriod": 86400
							
							},
							"dlr": true,
							"dlrUrl": "' . $callback . '",
							"externalTags": [
							"string"
							]
							}',
                            CURLOPT_HTTPHEADER => array(
                                'Authorization: Bearer ' . $api_key,
                                'Content-Type: application/json'
                            ),

                        )
                    );
                }

                $response = curl_exec($curl);
                $response = json_decode($response, true);
                $messageId = $response['messages'][0]['messageId'];
                $code = $response['messages'][0]['status']['code'];
                $message = $response['messages'][0]['status']['message'];
                Db::getInstance()->execute("insert into modulus_logs (messageId,code,message,msisdn,message_text) values ('$messageId','$code','$message','$phone_number','$message')");
                Db::getInstance()->execute("update modulus_pending_message set is_sent = 1 where id = '$id'");

                curl_close($curl);
            }
        }
    }

    public function hookDisplayBackOfficeHeader($params)
    {


        if ($this->context->controller->controller_name == 'AdminOrders') {
            $this->context->controller->addCSS($this->_path . 'views/css/syn_smsnotifications.css', 'all');
			//$this->context->controller->addJS('https://ajax.googleapis.com/ajax/libs/jquery/3.6.0/jquery.min.js');
            $this->context->controller->addJS($this->_path . 'views/js/syn_smsnotifications.js');
        }

    }

    // BACK IN STOCK SEND//
    public function hookActionUpdateQuantity($params)
    {
        $idProduct = $params['id_product'];
        $idProductAttr = $params['id_product_attribute'];

        $quantity = $params['quantity'];
        $sturl = $_SERVER['REQUEST_URI'];
        $domain = Tools::getShopDomain(true);
        $product_name = Db::getInstance()->getValue("select name from  " . _DB_PREFIX_ . "product_lang where id_product = '$idProduct' and id_lang = 1");
        $product_link = Db::getInstance()->getValue("select link_rewrite from  " . _DB_PREFIX_ . "product_lang where id_product = '$idProduct' and id_lang = 1");
        $url = $domain . '/' . $idProduct . '-' . $product_link . '.html';
        $text_ = $this->get_back_instock_template();

        $placeholders = array("{product_name}", "{product_url}");

        $values = array($product_name, $url);

        $smsreplace = str_replace($placeholders, $values, $text_);
        $text = $smsreplace;
        $api_url = Configuration::get("SYN_SMS_NOTIFICATIONS_API_URL");
        $callback = Context::getContext()->shop->getBaseURL(true) . "modules/SynSmsnotifications/callback.php";
        $routing_option = Configuration::get("SYN_SMS_NOTIFICATIONS_ROUTING_OPTION");

        $sender_id = Configuration::get("SYN_SMS_NOTIFICATIONS_SENDER_ID");
        $api_key = Configuration::get("SYN_SMS_NOTIFICATIONS_API_TOKEN");

        if ($quantity > 0) {

            $existInStock = Db::getInstance()->executeS("select phone_number from modulus_back_in_stock where product_id = '$idProduct' and notify_id = '0'");

            if (!empty($existInStock)) {
                foreach ($existInStock as $ex) {
                    $phone_number_initial = $ex['phone_number'];
                    $phone_number = $ex['phone_number'];
                    // $phone_number = '30' . $phone_numberstart;
                    if (substr($phone_number, 0, 3) !== '+30' && substr($phone_number, 0, 2) !== '30') {
                        $phone_number = '30' . $phone_number;
                    }
                    $todayNumber = date('N');
                    $inDays = Db::getInstance()->getValue("select days from modulus_time_rule");
                    $currentTimeWithoutSeconds = date('H:i');
                    $timefrom = Db::getInstance()->getValue("select timefrom from modulus_time_rule");
                    $timeto = Db::getInstance()->getValue("select timeto from modulus_time_rule");

                    if (!empty($inDays)) {
                        if (strpos($inDays, $todayNumber) !== false && ($currentTimeWithoutSeconds >= $timefrom && $currentTimeWithoutSeconds <= $timeto)) {

                            if ($routing_option == 'sms') {

                                $curl = curl_init();

                                curl_setopt_array(
                                    $curl,
                                    array(
                                        CURLOPT_URL => "$api_url",
                                        CURLOPT_RETURNTRANSFER => true,
                                        CURLOPT_ENCODING => '',
                                        CURLOPT_POST => 1,
                                        CURLOPT_MAXREDIRS => 10,
                                        CURLOPT_TIMEOUT => 0,
                                        CURLOPT_FOLLOWLOCATION => true,
                                        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                                        CURLOPT_CUSTOMREQUEST => 'POST',
                                        CURLOPT_POSTFIELDS => '{
							
										"priority": 3,
										"recipients": [
										{
										"msisdn": "' . $phone_number . '"
										}
										],
										
										"sms": {
										"sender": "' . $sender_id . '",
										"text": "' . $text . '",
										"encoding": "gsm",
										"validityPeriod": 86400
										
										},
										"dlr": true,
										"dlrUrl": "' . $callback . '",
										"externalTags": [
										"string"
										]
										}',
                                        CURLOPT_HTTPHEADER => array(
                                            'Authorization: Bearer ' . $api_key,
                                            'Content-Type: application/json'
                                        ),

                                    )
                                );
                            } else if ($routing_option == 'viber') {
                                $curl = curl_init();

                                curl_setopt_array(
                                    $curl,
                                    array(
                                        CURLOPT_URL => "$api_url",
                                        CURLOPT_RETURNTRANSFER => true,
                                        CURLOPT_ENCODING => '',
                                        CURLOPT_POST => 1,
                                        CURLOPT_MAXREDIRS => 10,
                                        CURLOPT_TIMEOUT => 0,
                                        CURLOPT_FOLLOWLOCATION => true,
                                        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                                        CURLOPT_CUSTOMREQUEST => 'POST',
                                        CURLOPT_POSTFIELDS => '{
							
										"routing": "viberTransactional",
										"priority": 3,
										"recipients": [
										{
										"msisdn": "' . $phone_number . '"
										}
										],
										"viber": {
										"sender": "' . $sender_id . '",
										"type": "text",
										"validityPeriod": 86400,
										"text": "' . $text . '",
										"encoding": "gsm"
										
										},
										
										"dlr": true,
										"dlrUrl": "' . $callback . '",
										"externalTags": [
										"string"
										]
										}',
                                        CURLOPT_HTTPHEADER => array(
                                            'Authorization: Bearer ' . $api_key,
                                            'Content-Type: application/json'
                                        ),

                                    )
                                );
                            } else if ($routing_option == 'viber2sms') {
                                $curl = curl_init();

                                curl_setopt_array(
                                    $curl,
                                    array(
                                        CURLOPT_URL => "$api_url",
                                        CURLOPT_RETURNTRANSFER => true,
                                        CURLOPT_ENCODING => '',
                                        CURLOPT_POST => 1,
                                        CURLOPT_MAXREDIRS => 10,
                                        CURLOPT_TIMEOUT => 0,
                                        CURLOPT_FOLLOWLOCATION => true,
                                        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                                        CURLOPT_CUSTOMREQUEST => 'POST',
                                        CURLOPT_POSTFIELDS => '{
							
										"routing": "viberTransactional2SMS",
										"priority": 3,
										"recipients": [
										{
										"msisdn": "' . $phone_number . '"
										}
										],
										"viber": {
										"sender": "' . $sender_id . '",
										"type": "text",
										"validityPeriod": 86400,
										"text": "' . $text . '",
										"encoding": "gsm"
										
										},
										"sms": {
										"sender": "' . $sender_id . '",
										"text": "' . $text . '",
										"encoding": "gsm",
										"validityPeriod": 86400
										
										},
										"dlr": true,
										"dlrUrl": "' . $callback . '",
										"externalTags": [
										"string"
										]
										}',
                                        CURLOPT_HTTPHEADER => array(
                                            'Authorization: Bearer ' . $api_key,
                                            'Content-Type: application/json'
                                        ),

                                    )
                                );
                            }

                            $response = curl_exec($curl);
                            $response = json_decode($response, true);
                            $messageId = $response['messages'][0]['messageId'];
                            $code = $response['messages'][0]['status']['code'];
                            $message = $response['messages'][0]['status']['message'];
                            Db::getInstance()->execute("insert into modulus_logs (messageId,code,message,msisdn,message_text) values ('$messageId','$code','$message','$phone_number','$text')");
                            Db::getInstance()->execute("update modulus_back_in_stock set notify_id = 1 where phone_number = '	$phone_number_initial' and product_id = '$idProduct'");

                            curl_close($curl);
                        } else {
                            Db::getInstance()->execute("insert into modulus_pending_message (phone_number,message,is_sent) values ('$phone_number','$text','0')");
                        }

                    } else {
                        if ($routing_option == 'sms') {

                            $curl = curl_init();

                            curl_setopt_array(
                                $curl,
                                array(
                                    CURLOPT_URL => "$api_url",
                                    CURLOPT_RETURNTRANSFER => true,
                                    CURLOPT_ENCODING => '',
                                    CURLOPT_POST => 1,
                                    CURLOPT_MAXREDIRS => 10,
                                    CURLOPT_TIMEOUT => 0,
                                    CURLOPT_FOLLOWLOCATION => true,
                                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                                    CURLOPT_CUSTOMREQUEST => 'POST',
                                    CURLOPT_POSTFIELDS => '{
						
									"priority": 3,
									"recipients": [
									{
									"msisdn": "' . $phone_number . '"
									}
									],
									
									"sms": {
									"sender": "' . $sender_id . '",
									"text": "' . $text . '",
									"encoding": "gsm",
									"validityPeriod": 86400
									
									},
									"dlr": true,
									"dlrUrl": "' . $callback . '",
									"externalTags": [
									"string"
									]
									}',
                                    CURLOPT_HTTPHEADER => array(
                                        'Authorization: Bearer ' . $api_key,
                                        'Content-Type: application/json'
                                    ),

                                )
                            );
                        } else if ($routing_option == 'viber') {
                            $curl = curl_init();

                            curl_setopt_array(
                                $curl,
                                array(
                                    CURLOPT_URL => "$api_url",
                                    CURLOPT_RETURNTRANSFER => true,
                                    CURLOPT_ENCODING => '',
                                    CURLOPT_POST => 1,
                                    CURLOPT_MAXREDIRS => 10,
                                    CURLOPT_TIMEOUT => 0,
                                    CURLOPT_FOLLOWLOCATION => true,
                                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                                    CURLOPT_CUSTOMREQUEST => 'POST',
                                    CURLOPT_POSTFIELDS => '{
						
									"routing": "viberTransactional",
									"priority": 3,
									"recipients": [
									{
									"msisdn": "' . $phone_number . '"
									}
									],
									"viber": {
									"sender": "' . $sender_id . '",
									"type": "text",
									"validityPeriod": 86400,
									"text": "' . $text . '",
									"encoding": "gsm"
									
									},
									
									"dlr": true,
									"dlrUrl": "' . $callback . '",
									"externalTags": [
									"string"
									]
									}',
                                    CURLOPT_HTTPHEADER => array(
                                        'Authorization: Bearer ' . $api_key,
                                        'Content-Type: application/json'
                                    ),

                                )
                            );
                        } else if ($routing_option == 'viber2sms') {
                            $curl = curl_init();

                            curl_setopt_array(
                                $curl,
                                array(
                                    CURLOPT_URL => "$api_url",
                                    CURLOPT_RETURNTRANSFER => true,
                                    CURLOPT_ENCODING => '',
                                    CURLOPT_POST => 1,
                                    CURLOPT_MAXREDIRS => 10,
                                    CURLOPT_TIMEOUT => 0,
                                    CURLOPT_FOLLOWLOCATION => true,
                                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                                    CURLOPT_CUSTOMREQUEST => 'POST',
                                    CURLOPT_POSTFIELDS => '{
						
									"routing": "viberTransactional2SMS",
									"priority": 3,
									"recipients": [
									{
									"msisdn": "' . $phone_number . '"
									}
									],
									"viber": {
									"sender": "' . $sender_id . '",
									"type": "text",
									"validityPeriod": 86400,
									"text": "' . $text . '",
									"encoding": "gsm"
									
									},
									"sms": {
									"sender": "' . $sender_id . '",
									"text": "' . $text . '",
									"encoding": "gsm",
									"validityPeriod": 86400
									
									},
									"dlr": true,
									"dlrUrl": "' . $callback . '",
									"externalTags": [
									"string"
									]
									}',
                                    CURLOPT_HTTPHEADER => array(
                                        'Authorization: Bearer ' . $api_key,
                                        'Content-Type: application/json'
                                    ),

                                )
                            );
                        }

                        $response = curl_exec($curl);

                        $response = json_decode($response, true);
                        $messageId = $response['messages'][0]['messageId'];
                        $code = $response['messages'][0]['status']['code'];
                        $message = $response['messages'][0]['status']['message'];
                        Db::getInstance()->execute("insert into modulus_logs (messageId,code,message,msisdn,message_text) values ('$messageId','$code','$message','$phone_number','$text')");
                        Db::getInstance()->execute("update modulus_back_in_stock set notify_id = 1 where phone_number = '$phone_number_initial' and product_id = '$idProduct'");

                        curl_close($curl);
//                        error_log(print_r($response), true);

                    }


                }
            }
        }
    }

    public function hookActionProductAttributeUpdate($params)
    {
        //$id_product_attribute = $params['id_product_attribute'];
        //error_log(print_r($id_product_attribute,true));
    }


    public function getcredentials()
    {
        $sender_id = Configuration::get("SYN_SMS_NOTIFICATIONS_SENDER_ID");
        $api_key = Configuration::get("SYN_SMS_NOTIFICATIONS_API_TOKEN");
        $api_secret = Configuration::get("SYN_SMS_NOTIFICATIONS_API_SECRET");
        $api_url = Configuration::get("SYN_SMS_NOTIFICATIONS_API_URL");
        $back_in_stock_status = Configuration::get("SYN_BACK_IN_STOCK_STATUS");
        $routing_option = Configuration::get("SYN_SMS_NOTIFICATIONS_ROUTING_OPTION");
        $this->context->smarty->assign('sender_id', $sender_id);
        $this->context->smarty->assign('api_key', $api_key);
        $this->context->smarty->assign('api_secret', $api_secret);
        $this->context->smarty->assign('back_in_stock_msg', $this->get_back_instock_template());
        $this->context->smarty->assign('back_in_stock_status', $back_in_stock_status);
        $this->context->smarty->assign('api_url', $api_url);
        $this->context->smarty->assign('routing_option', $routing_option);
    }

    public function save_credentials()
    {
        $api_url = Tools::getValue('api_url');
        $sender_id = Tools::getValue('senderid');
        $apikey = Tools::getValue('api_key');
        $apisecret = Tools::getValue('api_secret');
        $routing_option = Tools::getValue('routing_option');
        if ($api_url != '' && $api_url != null) {
            Configuration::updateValue("SYN_SMS_NOTIFICATIONS_API_URL", $api_url);
        }
        if ($sender_id != '' && $sender_id != null) {
            Configuration::updateValue("SYN_SMS_NOTIFICATIONS_SENDER_ID", $sender_id);
        }

        if ($apikey != '' && $apikey != null) {
            Configuration::updateValue("SYN_SMS_NOTIFICATIONS_API_TOKEN", $apikey);
        }

        if ($apisecret != '' && $apisecret != null) {
            Configuration::updateValue("SYN_SMS_NOTIFICATIONS_API_SECRET", $apisecret);
        }
        if ($routing_option != '' && $routing_option != null) {
            Configuration::updateValue("SYN_SMS_NOTIFICATIONS_ROUTING_OPTION", $routing_option);
        }


        $back_in_stock = Tools::getValue('activate_back_instock_checkbox');


        Configuration::updateValue("SYN_BACK_IN_STOCK_STATUS", $back_in_stock);
        if (Tools::getValue('back_in_stock_msg') != '') {
            $this->save_back_in_stock_template(Tools::getValue('back_in_stock_msg'));

        }
    }

    public function get_back_instock_template()
    {
        $existing_template_back_in_stock = Db::getInstance()->getValue("SELECT message FROM modulus_sms_back_in_stock_template WHERE id = 1");
        return $existing_template_back_in_stock;
    }

    public function save_back_in_stock_template($message)
    {
        $existing_template_back_in_stock = Db::getInstance()->executeS("SELECT * FROM modulus_sms_back_in_stock_template WHERE id = 1");
        if (!$existing_template_back_in_stock) {
            $title = 'Back INSTOCK template';
            $sql = "INSERT INTO modulus_sms_back_in_stock_template (title, message, language)
            VALUES ('$title', '$message', 'el')";
            Db::getInstance()->execute($sql);
        } else {
            $sql = "UPDATE modulus_sms_back_in_stock_template
                SET message = '$message'
                WHERE id = 1";
            Db::getInstance()->execute($sql);
        }


    }

    public function sendsms()
    {
        $phone_number = Tools::getValue('tel');
        $text = Tools::getValue('text');

        if ($phone_number != '' && $text != '') {
            // $phone_number = '30' . $phone_number;
            if (substr($phone_number, 0, 3) !== '+30' && substr($phone_number, 0, 2) !== '30') {
                $phone_number = '30' . $phone_number;
            }
            $todayNumber = date('N');
            $inDays = Db::getInstance()->getValue("select days from modulus_time_rule where active = 1");
            $currentTimeWithoutSeconds = date('H:i');
            $timefrom = Db::getInstance()->getValue("select timefrom from modulus_time_rule");
            $timeto = Db::getInstance()->getValue("select timeto from modulus_time_rule");


            $api_url = Configuration::get("SYN_SMS_NOTIFICATIONS_API_URL");
            $callback = Context::getContext()->shop->getBaseURL(true) . "modules/SynSmsnotifications/callback.php";

            $sender_id = Configuration::get("SYN_SMS_NOTIFICATIONS_SENDER_ID");
            $api_key = Configuration::get("SYN_SMS_NOTIFICATIONS_API_TOKEN");

            if (!empty($inDays)) {
                if ((strpos($inDays, $todayNumber) !== false && ($currentTimeWithoutSeconds >= $timefrom && $currentTimeWithoutSeconds <= $timeto)) || ($inDays == '' && $timefrom == '' && $timeto == '')) {
                    $curl = curl_init();

                    curl_setopt_array(
                        $curl,
                        array(
                            CURLOPT_URL => "$api_url",
                            CURLOPT_RETURNTRANSFER => true,
                            CURLOPT_ENCODING => '',
                            CURLOPT_MAXREDIRS => 10,
                            CURLOPT_TIMEOUT => 0,
                            CURLOPT_FOLLOWLOCATION => true,
                            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                            CURLOPT_CUSTOMREQUEST => 'POST',
                            CURLOPT_POSTFIELDS => '{

					  "priority": 3,
					  "recipients": [
						{
						  "msisdn": "' . $phone_number . '"
						}
					  ],

					  "sms": {
						"sender": "' . $sender_id . '",
						"text": "' . $text . '",
						"encoding": "gsm",
						"validityPeriod": 86400

					  },
					  "dlr": true,
					  "dlrUrl":  "' . $callback . '",
					  "externalTags": [
						"string"
					  ]
					}',
                            CURLOPT_HTTPHEADER => array(
                                'Authorization: Bearer ' . $api_key,
                                'Content-Type: application/json'
                            ),
                        )
                    );

                    $response = curl_exec($curl);
                    $response = json_decode($response, true);
                    $messageId = $response['messages'][0]['messageId'];
                    $code = $response['messages'][0]['status']['code'];
                    $message = $response['messages'][0]['status']['message'];
                    Db::getInstance()->execute("insert into modulus_logs (messageId,code,message,msisdn,message_text) values ('$messageId','$code','$message','$phone_number','$text')");

                    curl_close($curl);
                    return $response;

                } else {

                    Db::getInstance()->execute("insert into modulus_pending_message (phone_number,message,is_sent) values ('$phone_number','$text','0')");
                }
            } else {
                $curl = curl_init();

                curl_setopt_array(
                    $curl,
                    array(
                        CURLOPT_URL => "$api_url",
                        CURLOPT_RETURNTRANSFER => true,
                        CURLOPT_ENCODING => '',
                        CURLOPT_POST => 1,
                        CURLOPT_MAXREDIRS => 10,
                        CURLOPT_TIMEOUT => 0,
                        CURLOPT_FOLLOWLOCATION => true,
                        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                        CURLOPT_CUSTOMREQUEST => 'POST',
                        CURLOPT_POSTFIELDS => '{

							"priority": 3,
							"recipients": [
							  {
								"msisdn": "' . $phone_number . '"
							  }
							],
	  
							"sms": {
							  "sender": "' . $sender_id . '",
							  "text": "' . $text . '",
							  "encoding": "gsm",
							  "validityPeriod": 86400
	  
							},
							"dlr": true,
							"dlrUrl":  "' . $callback . '",
							"externalTags": [
							  "string"
							]
						  }',
                        CURLOPT_HTTPHEADER => array(
                            'Authorization: Bearer ' . $api_key,
                            'Content-Type: application/json'
                        ),

                    )
                );

                $response = curl_exec($curl);
                $response = json_decode($response, true);
                $messageId = $response['messages'][0]['messageId'];
                $code = $response['messages'][0]['status']['code'];
                $message = $response['messages'][0]['status']['message'];

                Db::getInstance()->execute("insert into modulus_logs (messageId,code,message,msisdn,message_text) values ('$messageId','$code','$message','$phone_number','$text')");


                curl_close($curl);
                return $response;//$code;

            }


        }

    }

    public function sendsmsCust($phone_number, $text)
    {
        //$phone_number = Tools::getValue('tel');
        //$text = Tools::getValue('text');

        if ($phone_number != '' && $text != '') {
            // $phone_number = '30' . $phone_number;
            if (substr($phone_number, 0, 3) !== '+30' && substr($phone_number, 0, 2) !== '30') {
                $phone_number = '30' . $phone_number;
            }
            $todayNumber = date('N');
            $inDays = Db::getInstance()->getValue("select days from modulus_time_rule where active = 1");
            $currentTimeWithoutSeconds = date('H:i');
            $timefrom = Db::getInstance()->getValue("select timefrom from modulus_time_rule");
            $timeto = Db::getInstance()->getValue("select timeto from modulus_time_rule");


            $api_url = Configuration::get("SYN_SMS_NOTIFICATIONS_API_URL");
            $callback = Context::getContext()->shop->getBaseURL(true) . "modules/SynSmsnotifications/callback.php";

            $sender_id = Configuration::get("SYN_SMS_NOTIFICATIONS_SENDER_ID");
            $api_key = Configuration::get("SYN_SMS_NOTIFICATIONS_API_TOKEN");

            if (!empty($inDays)) {
                if ((strpos($inDays, $todayNumber) !== false && ($currentTimeWithoutSeconds >= $timefrom && $currentTimeWithoutSeconds <= $timeto)) || ($inDays == '' && $timefrom == '' && $timeto == '')) {
                    $curl = curl_init();

                    curl_setopt_array(
                        $curl,
                        array(
                            CURLOPT_URL => "$api_url",
                            CURLOPT_RETURNTRANSFER => true,
                            CURLOPT_ENCODING => '',
                            CURLOPT_MAXREDIRS => 10,
                            CURLOPT_TIMEOUT => 0,
                            CURLOPT_FOLLOWLOCATION => true,
                            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                            CURLOPT_CUSTOMREQUEST => 'POST',
                            CURLOPT_POSTFIELDS => '{

					  "priority": 3,
					  "recipients": [
						{
						  "msisdn": "' . $phone_number . '"
						}
					  ],

					  "sms": {
						"sender": "' . $sender_id . '",
						"text": "' . $text . '",
						"encoding": "gsm",
						"validityPeriod": 86400

					  },
					  "dlr": true,
					  "dlrUrl":  "' . $callback . '",
					  "externalTags": [
						"string"
					  ]
					}',
                            CURLOPT_HTTPHEADER => array(
                                'Authorization: Bearer ' . $api_key,
                                'Content-Type: application/json'
                            ),
                        )
                    );

                    $response = curl_exec($curl);
                    $response = json_decode($response, true);
                    $messageId = $response['messages'][0]['messageId'];
                    $code = $response['messages'][0]['status']['code'];
                    $message = $response['messages'][0]['status']['message'];
                    Db::getInstance()->execute("insert into modulus_logs (messageId,code,message,msisdn,message_text) values ('$messageId','$code','$message','$phone_number','$text')");

                    curl_close($curl);
                    return $response;

                } else {

                    Db::getInstance()->execute("insert into modulus_pending_message (phone_number,message,is_sent) values ('$phone_number','$text','0')");
                }
            } else {
                $curl = curl_init();

                curl_setopt_array(
                    $curl,
                    array(
                        CURLOPT_URL => "$api_url",
                        CURLOPT_RETURNTRANSFER => true,
                        CURLOPT_ENCODING => '',
                        CURLOPT_POST => 1,
                        CURLOPT_MAXREDIRS => 10,
                        CURLOPT_TIMEOUT => 0,
                        CURLOPT_FOLLOWLOCATION => true,
                        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                        CURLOPT_CUSTOMREQUEST => 'POST',
                        CURLOPT_POSTFIELDS => '{

							"priority": 3,
							"recipients": [
							  {
								"msisdn": "' . $phone_number . '"
							  }
							],
	  
							"sms": {
							  "sender": "' . $sender_id . '",
							  "text": "' . $text . '",
							  "encoding": "gsm",
							  "validityPeriod": 86400
	  
							},
							"dlr": true,
							"dlrUrl":  "' . $callback . '",
							"externalTags": [
							  "string"
							]
						  }',
                        CURLOPT_HTTPHEADER => array(
                            'Authorization: Bearer ' . $api_key,
                            'Content-Type: application/json'
                        ),

                    )
                );

                $response = curl_exec($curl);
                $response = json_decode($response, true);
                $messageId = $response['messages'][0]['messageId'];
                $code = $response['messages'][0]['status']['code'];
                $message = $response['messages'][0]['status']['message'];

                Db::getInstance()->execute("insert into modulus_logs (messageId,code,message,msisdn,message_text) values ('$messageId','$code','$message','$phone_number','$text')");

                curl_close($curl);
                return $response;//$code;

            }

        }

    }


    public function getTemplates()
    {
        $sqlselector = Db::getInstance()->executeS("select * from syn_smstemplates order by id asc");

        foreach ($sqlselector as $res) {
            $id = $res['id'];
            $sms = $res['sms'];
            $id_lang = $res['id_lang'];
            $creation_date = $res['creation_date'];
            $last_edit_date = $res['last_edit_date'];
            $title_sms = $res['title_sms'];
            $id_lang = Db::getInstance()->getValue("select iso_code from  " . _DB_PREFIX_ . "lang where id_lang = '$id_lang'");


            $smsarray[] = [
                'id' => $id,
                'sms' => $sms,
                'id_lang' => $id_lang,
                'creation_date' => $creation_date,
                'last_edit_date' => $last_edit_date,
                'title_sms' => $title_sms,
            ];
        }
        return $smsarray;
    }

    public function getLangs()
    {
        $sql = Db::getInstance()->executeS("select * from  " . _DB_PREFIX_ . "lang order by id_lang asc");

        foreach ($sql as $l) {
            $id_lang = $l['id_lang'];
            $iso = $l['iso_code'];

            $lang_array[] = [
                'id_lang' => $id_lang,
                'iso' => $iso
            ];
        }
        return $lang_array;
    }

    public function updateSms()
    {
        $id = Tools::getValue("hiddenval");
        $title = Tools::getValue("Τίτλος");
        $sms = Tools::getValue("Μήνυμα");
        $id_lang = Tools::getValue("id_language");
        $id_langint = Db::getInstance()->getValue("select id_lang from  " . _DB_PREFIX_ . "lang where iso_code = '$id_lang'");
        $todayDate = date("Y-m-d H:i:s");

        Db::getInstance()->execute("update syn_smstemplates set sms = '$sms', title_sms = '$title', last_edit_date = '$todayDate', id_lang = '$id_langint' where id = '$id'");
    }

    public function deleteSms()
    {
        $id = Tools::getValue('sms_id2');
        Db::getInstance()->execute("delete from syn_smstemplates where id = '$id'");
    }

    public function insertSms()
    {
        //error_log('create sms temp');
        $sms = Tools::getValue('create_sms');
        $sms_text = Tools::getValue('create_sms_text');
        $id_lang = Tools::getValue('id_language');
        $id_langint = Db::getInstance()->getValue("select id_lang from  " . _DB_PREFIX_ . "lang where iso_code = '$id_lang'");
        $todayDate = date("Y-m-d H:i:s");

        Db::getInstance()->execute("insert into syn_smstemplates (sms,creation_date,last_edit_date,title_sms,id_lang) values ('$sms_text','$todayDate','$todayDate','$sms','$id_langint')");


    }

    public function getOrderStates()
    {
        $sqlselector = Db::getInstance()->executeS("select * from  " . _DB_PREFIX_ . "order_state_lang order by id_order_state");

        foreach ($sqlselector as $res) {
            $id_order_state = $res['id_order_state'];
            $name = $res['name'];
            $id_lang = $res['id_lang'];
            $lang_iso = Db::getInstance()->getValue("select iso_code from  " . _DB_PREFIX_ . "lang where id_lang = '$id_lang'");
            $active = Db::getInstance()->getValue("select active from syn_smsordertemplates where id_order_status = '$id_order_state' and id_lang = '$id_lang'");
            $id_template = Db::getInstance()->getValue("select id_template from syn_smsordertemplates where id_order_status = '$id_order_state' and id_lang = '$id_lang'");

            $order_states[] = [
                'id' => $id_order_state,
                'name' => $name,
                'id_lang' => $id_lang,
                'iso' => $lang_iso,
                'active' => $active,
                'id_template' => $id_template,
            ];
        }
        return $order_states;
    }
	
	public function hookDisplayAdminOrder($params)
	{

		$id_order = $params['id_order'];
		$idLang = Db::getInstance()->getValue("select id_lang from  " . _DB_PREFIX_ . "orders where id_order = '$id_order'");
		$order_obj = new Order($id_order);
		$address_obj = new Address($order_obj->id_address_delivery);
		$phone = $address_obj->phone_mobile;
		if ($phone == "") {
			$phone = $address_obj->phone;
		}
		$this->smarty->assign([
			'templates' => $this->getSMSTemplates($idLang),
			'id_order' => $id_order,
			'customer_phone' => "30" . str_replace([" ", "-"], "", $phone),
			'sms_history' => $this->getSMSHistory($id_order),
		]);
		return $this->display(__FILE__, 'views/templates/sms-notifications.tpl');
	}


    public function hookDisplayAdminOrderSideBottom($params)
    {

        $id_order = $params['id_order'];
        $idLang = Db::getInstance()->getValue("select id_lang from  " . _DB_PREFIX_ . "orders where id_order = '$id_order'");
        $order_obj = new Order($id_order);
        $address_obj = new Address($order_obj->id_address_delivery);
        $phone = $address_obj->phone_mobile;
        if ($phone == "") {
            $phone = $address_obj->phone;
        }
		
		if(isset($_GET['error']) && $_GET['error'] ==1){
		 	$this->context->smarty->assign('error_message', 'Something Went Wrong');


		}
        $this->smarty->assign([
            'templates' => $this->getSMSTemplates($idLang),
            'id_order' => $id_order,
            'customer_phone' => "30" . str_replace([" ", "-"], "", $phone),
            'sms_history' => $this->getSMSHistory($id_order),
        ]);
        return $this->display(__FILE__, 'views/templates/sms-notifications.tpl');
    }

	
    public function getCustomers()
    {
        // Get the current page number
        $currentPage = (int)Tools::getValue('paged', 1);
        $rowsPerPage = 10; // Adjust rows per page as needed
        $offset = ($currentPage - 1) * $rowsPerPage;

        // Get specific search parameter
        $specific_search = Tools::getValue('specificsearch', '');

        $specific_search = pSQL($specific_search); // Sanitize user input

        // Build the base query for customers
        $whereClause = !empty($specific_search)
            ? "WHERE firstname LIKE '%$specific_search%' OR lastname LIKE '%$specific_search%'"
            : "";

        $customerQuery = "
        SELECT c.id_customer, c.firstname, c.lastname, c.email, c.id_lang, l.iso_code
        FROM " . _DB_PREFIX_ . "customer c
        LEFT JOIN " . _DB_PREFIX_ . "lang l ON c.id_lang = l.id_lang
        $whereClause
        ORDER BY c.id_customer ASC
        LIMIT $offset, $rowsPerPage
    ";

        $customers = Db::getInstance()->executeS($customerQuery);
        if (empty($customers)) {
            return [
                'customers' => [],
                'totalPages' => 0,
                'currentPage' => $currentPage,
                'prevPageUrl' => null,
                'nextPageUrl' => null,
                'paginationUrls' => []
            ];
        }

        // Fetch additional data for each customer
        $customer_array = [];
        foreach ($customers as $c) {
            $id_customer = (int)$c['id_customer'];

            // Get customer groups
            $groupQuery = "
            SELECT g.name
            FROM " . _DB_PREFIX_ . "customer_group cg
            LEFT JOIN " . _DB_PREFIX_ . "group_lang g ON cg.id_group = g.id_group
            WHERE cg.id_customer = $id_customer AND g.id_lang = 1
        ";
            $groups = Db::getInstance()->executeS($groupQuery);
            $groupNames = array_column($groups, 'name');
            $groupStr = implode(',', $groupNames);

            // Get customer phones
            $phoneQuery = "
            SELECT phone
            FROM " . _DB_PREFIX_ . "address
            WHERE id_customer = $id_customer
        ";
            $phones = Db::getInstance()->executeS($phoneQuery);
            $phoneNumbers = !empty($phones) ? array_column($phones, 'phone') : ['--'];

            $customer_array[] = [
                'id_customer' => $id_customer,
                'firstname' => $c['firstname'],
                'lastname' => $c['lastname'],
                'email' => $c['email'],
                'phone' => implode(', ', $phoneNumbers),
                'groups' => $groupStr,
                'id_lang' => $c['id_lang'],
                'iso' => $c['iso_code']
            ];
        }

        // Get the total number of customers
        $countQuery = "
        SELECT COUNT(*) 
        FROM " . _DB_PREFIX_ . "customer c
        $whereClause
    ";
        $totalCustomers = (int)Db::getInstance()->getValue($countQuery);
        $totalPages = ceil($totalCustomers / $rowsPerPage);

        // Generate pagination URLs
        $baseUrl = preg_replace('/&paged=\d+/', '', $_SERVER['REQUEST_URI']); // Clean the base URL
        $paginationUrls = [];
        for ($i = 1; $i <= $totalPages; $i++) {
            $paginationUrls[] = [
                'page' => $i,
                'url' => $baseUrl . '&paged=' . $i
            ];
        }

        // Determine previous and next page URLs
        $prevPageUrl = ($currentPage > 1) ? $baseUrl . '&paged=' . ($currentPage - 1) : null;
        $nextPageUrl = ($currentPage < $totalPages) ? $baseUrl . '&paged=' . ($currentPage + 1) : null;

        // Return the final result
        return [
            'customers' => $customer_array,
            'totalPages' => $totalPages,
            'currentPage' => $currentPage,
            'prevPageUrl' => $prevPageUrl,
            'nextPageUrl' => $nextPageUrl,
            'paginationUrls' => $paginationUrls
        ];
    }


    public function hookDisplayAdminCustomers($params)
    {

        if (Tools::isSubmit("again_send")) {
            $sms = Tools::getValue('sms');
            $phone_num = Tools::getValue('phone_num');
            $id_customer_again = Tools::getValue('id_customer_again');

            $encoded_params = json_encode($params, JSON_UNESCAPED_UNICODE);
            $res = $this->sendsmsCust($phone_num, $sms);

            // record repsonse
            $curl_response = 'test resp';
            $employee_id = $this->context->employee->id;
            Db::getInstance()->execute("INSERT INTO `syn_order_sms`(`id_customer`,  `id_employee`, `message`, `response`, `phone`, `date_add`) 
						VALUES ($id_customer_again, $employee_id, '$sms', '$curl_response', '$phone_num', NOW())");
        }

        $customerId = $params['id_customer'];
        $idLang = Db::getInstance()->getValue("select id_lang from  " . _DB_PREFIX_ . "customer where id_customer = '$customerId'");
        $phones_array = array();
        $phones = Db::getInstance()->getValue("select phone from  " . _DB_PREFIX_ . "address where id_customer = '$customerId'");
        foreach ($phones as $phone) {
            $phone = $phone['phone'];
            array_push($phones_array, $phone);
        }

        if ($phone == "") {
            // $phone = $address_obj->phone;
        }
		
        $this->smarty->assign([
            'templates' => $this->getSMSTemplates(null),
            'id_customer' => $customerId,
            'phones' => $phones,
            'sms_history' => $this->getSMSHistoryCust($customerId),
        ]);
        return $this->display(__FILE__, 'views/templates/sms-customer-notifications.tpl');
    }

    public function getRules()
    {
        $sqlselector = Db::getInstance()->executeS("select * from modulus_time_rule order by id_rule asc");


        foreach ($sqlselector as $res) {
            $days_array_str = array();
            $id_rule = $res['id_rule'];
            $days = $res['days'];
            $starttime = $res['timefrom'];
            $endtime = $res['timeto'];
            $days_array = explode(',', $days);


            foreach ($days_array as $d) {
                if ($d == 1) {
                    array_push($days_array_str, 'Δευτέρα');
                } elseif ($d == 2) {
                    array_push($days_array_str, 'Τρίτη');
                } elseif ($d == 3) {
                    array_push($days_array_str, 'Τετάρτη');
                } elseif ($d == 4) {
                    array_push($days_array_str, 'Πέμπτη');
                } elseif ($d == 5) {
                    array_push($days_array_str, 'Παρασκευή');
                } elseif ($d == 6) {
                    array_push($days_array_str, 'Σάββατο');
                } elseif ($d == 7) {
                    array_push($days_array_str, 'Κυριακή');
                }
            }
            $daysf = implode(',', $days_array_str);

            $rule_array[] = [
                'id' => $id_rule,
                'days' => $daysf,
                'start_time' => $starttime,
                'end_time' => $endtime
            ];
        }
        return $rule_array;
    }

    public function get_time_rules()
    {
        $sqlselector = Db::getInstance()->executeS("select * from modulus_time_rule WHERE id_rule=1");


        foreach ($sqlselector as $res) {
            $days_array_str = array();
            $id_rule = $res['id_rule'];
            $days = $res['days'];
            $starttime = $res['timefrom'];
            $endtime = $res['timeto'];
            $status = $res['active'];
            $days_array = explode(',', $days);


            foreach ($days_array as $d) {
                if ($d == 1) {
                    array_push($days_array_str, 'Δευτέρα');
                } elseif ($d == 2) {
                    array_push($days_array_str, 'Τρίτη');
                } elseif ($d == 3) {
                    array_push($days_array_str, 'Τετάρτη');
                } elseif ($d == 4) {
                    array_push($days_array_str, 'Πέμπτη');
                } elseif ($d == 5) {
                    array_push($days_array_str, 'Παρασκευή');
                } elseif ($d == 6) {
                    array_push($days_array_str, 'Σάββατο');
                } elseif ($d == 7) {
                    array_push($days_array_str, 'Κυριακή');
                }
            }


            $rule_array[] = [
                'id' => $id_rule,
                'days' => $days_array,
                'start_time' => $starttime,
                'end_time' => $endtime,
                'status' => $status
            ];
        }
        return $rule_array;

    }

    public function deleteRule()
    {
        $id_rule = Tools::getValue('sms_id2');

        // First, delete the row
        Db::getInstance()->execute("DELETE FROM modulus_time_rule WHERE id_rule = '$id_rule'");

        // Then, reset the autoincrement value
        Db::getInstance()->execute("ALTER TABLE modulus_time_rule AUTO_INCREMENT = 1;");

    }

    public function hookActionOrderStatusPostUpdate($params)
    {

        $sender_id = Configuration::get("SYN_SMS_NOTIFICATIONS_SENDER_ID");
        $api_key = Configuration::get("SYN_SMS_NOTIFICATIONS_API_TOKEN");

        $id_order = $params['id_order'];
        $id_lang = Db::getInstance()->getValue("select id_lang from  " . _DB_PREFIX_ . "orders where id_order = '$id_order'");
        $order_reference = Db::getInstance()->getValue("select reference from  " . _DB_PREFIX_ . "orders where id_order = '$id_order'");
        $id_address_delivery = Db::getInstance()->getValue("select id_address_delivery from " . _DB_PREFIX_ . "orders where id_order = '$id_order'");
        $mobile_phone = Db::getInstance()->getValue("select phone from  " . _DB_PREFIX_ . "address where id_address = '$id_address_delivery'");
        $mobile_phone = '30' . $mobile_phone;
        $order_state = $params['newOrderStatus']->id;

//        error_log($mobile_phone);
        // TOTAL //
        $total_currency = 'SELECT total_paid, id_currency FROM ' . _DB_PREFIX_ . 'orders WHERE id_order = ' . (int)$id_order;
        $result = Db::getInstance()->getRow($total_currency);
        $api_url = Configuration::get("SYN_SMS_NOTIFICATIONS_API_URL");

        $total_formatted = Tools::displayPrice($result['total_paid'], Currency::getCurrencyInstance($result['id_currency']));

        $order_total = $total_formatted;//Db::getInstance()->getValue("SELECT total_paid FROM ps_orders WHERE id_order = $id_order");

        // USER DETAILS
        $fetch_user_details = 'SELECT c.firstname, c.lastname 
        FROM ' . _DB_PREFIX_ . 'orders o
        LEFT JOIN ' . _DB_PREFIX_ . 'customer c ON o.id_customer = c.id_customer 
        WHERE o.id_order = ' . (int)$id_order;

        $result = Db::getInstance()->getRow($fetch_user_details);

        $first_name = $result['firstname'];
        $last_name = $result['lastname'];

        $shipping_number = Db::getInstance()->getValue('SELECT tracking_number FROM ' . _DB_PREFIX_ . 'order_carrier WHERE id_order = ' . (int)$id_order);
        $callback = Context::getContext()->shop->getBaseURL(true) . "modules/SynSmsnotifications/callback.php";

        // TEMPLATE FETCH
        $exist = Db::getInstance()->getValue("select id_template from syn_smsordertemplates where id_order_status = '$order_state' and id_lang = '$id_lang' and active = 1");

        if (!empty($exist)) {
            $smstext = Db::getInstance()->getValue("select sms from syn_smstemplates where id = '$exist'");

            $placeholders = array("{first_name}", "{last_name}", "{order_id}", "{order_total}", "{shipping_number}");

            $values = array($first_name, $last_name, $id_order, $order_total, $shipping_number);

            $smsreplace = str_replace($placeholders, $values, $smstext);

            $smstext = $smsreplace;

            if ($mobile_phone != '') {

                $todayNumber = date('N');
                $inDays = Db::getInstance()->getValue("select days from modulus_time_rule where active = 1");
                $currentTimeWithoutSeconds = date('H:i');
                $timefrom = Db::getInstance()->getValue("select timefrom from modulus_time_rule");
                $timeto = Db::getInstance()->getValue("select timeto from modulus_time_rule");
                $routing_option = Configuration::get("SYN_SMS_NOTIFICATIONS_ROUTING_OPTION");
                // ADD +30 IF IT DOES NOT EXIST TO THE MOBILE NUMBER
                if (substr($mobile_phone, 0, 3) !== '+30' && substr($mobile_phone, 0, 2) !== '30') {
                    $mobile_phone = '30' . $mobile_phone;
                }


                if (!empty($inDays)) {
                    if (strpos($inDays, $todayNumber) !== false && ($currentTimeWithoutSeconds >= $timefrom && $currentTimeWithoutSeconds <= $timeto)) {


                        if ($routing_option == 'sms') {

                            $curl = curl_init();

                            curl_setopt_array(
                                $curl,
                                array(
                                    CURLOPT_URL => "$api_url",
                                    CURLOPT_RETURNTRANSFER => true,
                                    CURLOPT_ENCODING => '',
                                    CURLOPT_POST => 1,
                                    CURLOPT_MAXREDIRS => 10,
                                    CURLOPT_TIMEOUT => 0,
                                    CURLOPT_FOLLOWLOCATION => true,
                                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                                    CURLOPT_CUSTOMREQUEST => 'POST',
                                    CURLOPT_POSTFIELDS => '{
						
									"priority": 3,
									"recipients": [
									{
									"msisdn": "' . $mobile_phone . '"
									}
									],
									
									"sms": {
									"sender": "' . $sender_id . '",
									"text": "' . $smstext . '",
									"encoding": "gsm",
									"validityPeriod": 86400
									
									},
									"dlr": true,
									"dlrUrl": "' . $callback . '",
									"externalTags": [
									"string"
									]
									}',
                                    CURLOPT_HTTPHEADER => array(
                                        'Authorization: Bearer ' . $api_key,
                                        'Content-Type: application/json'
                                    ),

                                )
                            );
                        } else if ($routing_option == 'viber') {
                            $curl = curl_init();

                            curl_setopt_array(
                                $curl,
                                array(
                                    CURLOPT_URL => "$api_url",
                                    CURLOPT_RETURNTRANSFER => true,
                                    CURLOPT_ENCODING => '',
                                    CURLOPT_POST => 1,
                                    CURLOPT_MAXREDIRS => 10,
                                    CURLOPT_TIMEOUT => 0,
                                    CURLOPT_FOLLOWLOCATION => true,
                                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                                    CURLOPT_CUSTOMREQUEST => 'POST',
                                    CURLOPT_POSTFIELDS => '{
						
									"routing": "viberTransactional",
									"priority": 3,
									"recipients": [
									{
									"msisdn": "' . $mobile_phone . '"
									}
									],
									"viber": {
									"sender": "' . $sender_id . '",
									"type": "text",
									"validityPeriod": 86400,
									"text": "' . $smstext . '",
									"encoding": "gsm"
									
									},
									
									"dlr": true,
									"dlrUrl": "' . $callback . '",
									"externalTags": [
									"string"
									]
									}',
                                    CURLOPT_HTTPHEADER => array(
                                        'Authorization: Bearer ' . $api_key,
                                        'Content-Type: application/json'
                                    ),

                                )
                            );
                        } else if ($routing_option == 'viber2sms') {
                            $curl = curl_init();

                            curl_setopt_array(
                                $curl,
                                array(
                                    CURLOPT_URL => "$api_url",
                                    CURLOPT_RETURNTRANSFER => true,
                                    CURLOPT_ENCODING => '',
                                    CURLOPT_POST => 1,
                                    CURLOPT_MAXREDIRS => 10,
                                    CURLOPT_TIMEOUT => 0,
                                    CURLOPT_FOLLOWLOCATION => true,
                                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                                    CURLOPT_CUSTOMREQUEST => 'POST',
                                    CURLOPT_POSTFIELDS => '{
						
									"routing": "viberTransactional2SMS",
									"priority": 3,
									"recipients": [
									{
									"msisdn": "' . $mobile_phone . '"
									}
									],
									"viber": {
									"sender": "' . $sender_id . '",
									"type": "text",
									"validityPeriod": 86400,
									"text": "' . $smstext . '",
									"encoding": "gsm"
									
									},
									"sms": {
									"sender": "' . $sender_id . '",
									"text": "' . $smstext . '",
									"encoding": "gsm",
									"validityPeriod": 86400
									
									},
									"dlr": true,
									"dlrUrl": "' . $callback . '",
									"externalTags": [
									"string"
									]
									}',
                                    CURLOPT_HTTPHEADER => array(
                                        'Authorization: Bearer ' . $api_key,
                                        'Content-Type: application/json'
                                    ),

                                )
                            );
                        }

                        $response = curl_exec($curl);
                        $response = json_decode($response, true);
                        $messageId = $response['messages'][0]['messageId'];
                        $code = $response['messages'][0]['status']['code'];
                        $message = $response['messages'][0]['status']['message'];
                        Db::getInstance()->execute("insert into modulus_logs (messageId,code,message,msisdn,message_text) values ('$messageId','$code','$message','$mobile_phone','$smstext')");

                        curl_close($curl);

                    } else {
                        Db::getInstance()->execute("insert into modulus_pending_message (phone_number,message,is_sent) values ('$mobile_phone','$smstext','0')");
                    }
                } else {
                    if ($routing_option == 'sms') {

                        $curl = curl_init();

                        curl_setopt_array(
                            $curl,
                            array(
                                CURLOPT_URL => "$api_url",
                                CURLOPT_RETURNTRANSFER => true,
                                CURLOPT_ENCODING => '',
                                CURLOPT_POST => 1,
                                CURLOPT_MAXREDIRS => 10,
                                CURLOPT_TIMEOUT => 0,
                                CURLOPT_FOLLOWLOCATION => true,
                                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                                CURLOPT_CUSTOMREQUEST => 'POST',
                                CURLOPT_POSTFIELDS => '{
						
									"priority": 3,
									"recipients": [
									{
									"msisdn": "' . $mobile_phone . '"
									}
									],
									
									"sms": {
									"sender": "' . $sender_id . '",
									"text": "' . $smstext . '",
									"encoding": "gsm",
									"validityPeriod": 86400
									
									},
									"dlr": true,
									"dlrUrl": "' . $callback . '",
									"externalTags": [
									"string"
									]
									}',
                                CURLOPT_HTTPHEADER => array(
                                    'Authorization: Bearer ' . $api_key,
                                    'Content-Type: application/json'
                                ),

                            )
                        );
                    } else if ($routing_option == 'viber') {
                        $curl = curl_init();

                        curl_setopt_array(
                            $curl,
                            array(
                                CURLOPT_URL => "$api_url",
                                CURLOPT_RETURNTRANSFER => true,
                                CURLOPT_ENCODING => '',
                                CURLOPT_POST => 1,
                                CURLOPT_MAXREDIRS => 10,
                                CURLOPT_TIMEOUT => 0,
                                CURLOPT_FOLLOWLOCATION => true,
                                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                                CURLOPT_CUSTOMREQUEST => 'POST',
                                CURLOPT_POSTFIELDS => '{
						
									"routing": "viberTransactional",
									"priority": 3,
									"recipients": [
									{
									"msisdn": "' . $mobile_phone . '"
									}
									],
									"viber": {
									"sender": "' . $sender_id . '",
									"type": "text",
									"validityPeriod": 86400,
									"text": "' . $smstext . '",
									"encoding": "gsm"
									
									},
									
									"dlr": true,
									"dlrUrl": "' . $callback . '",
									"externalTags": [
									"string"
									]
									}',
                                CURLOPT_HTTPHEADER => array(
                                    'Authorization: Bearer ' . $api_key,
                                    'Content-Type: application/json'
                                ),

                            )
                        );
                    } else if ($routing_option == 'viber2sms') {
                        $curl = curl_init();

                        curl_setopt_array(
                            $curl,
                            array(
                                CURLOPT_URL => "$api_url",
                                CURLOPT_RETURNTRANSFER => true,
                                CURLOPT_ENCODING => '',
                                CURLOPT_POST => 1,
                                CURLOPT_MAXREDIRS => 10,
                                CURLOPT_TIMEOUT => 0,
                                CURLOPT_FOLLOWLOCATION => true,
                                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                                CURLOPT_CUSTOMREQUEST => 'POST',
                                CURLOPT_POSTFIELDS => '{
						
									"routing": "viberTransactional2SMS",
									"priority": 3,
									"recipients": [
									{
									"msisdn": "' . $mobile_phone . '"
									}
									],
									"viber": {
									"sender": "' . $sender_id . '",
									"type": "text",
									"validityPeriod": 86400,
									"text": "' . $smstext . '",
									"encoding": "gsm"
									
									},
									"sms": {
									"sender": "' . $sender_id . '",
									"text": "' . $smstext . '",
									"encoding": "gsm",
									"validityPeriod": 86400
									
									},
									"dlr": true,
									"dlrUrl": "' . $callback . '",
									"externalTags": [
									"string"
									]
									}',
                                CURLOPT_HTTPHEADER => array(
                                    'Authorization: Bearer ' . $api_key,
                                    'Content-Type: application/json'
                                ),

                            )
                        );
                    }

                    $response = curl_exec($curl);
                    $response = json_decode($response, true);
                    $messageId = $response['messages'][0]['messageId'];
                    $code = $response['messages'][0]['status']['code'];
                    $message = $response['messages'][0]['status']['message'];

                    Db::getInstance()->execute("insert into modulus_logs (messageId,code,message,msisdn,message_text) values ('$messageId','$code','$message','$mobile_phone','$smstext')");

                    curl_close($curl);
                }

            }

        }


    }

    public function getContent()
    {
		
        $this->context->smarty->assign('csrf', Tools::encrypt("SynSmsnotifications"));
        $this->context->smarty->assign('tabs_template', _PS_MODULE_DIR_ . '/views/templates/admin_tabs.tpl');

        $baseUrl = $_SERVER['REQUEST_URI']; // Get current URL
        $baseUrl = preg_replace('/([&?])(smstab|specificsearch|paged)=[^&]*/', '', $baseUrl);

        $this->context->smarty->assign('adminurl', $baseUrl);

        $adminLink = $this->context->link->getAdminLink('AdminSMSNotifications');
        $this->context->smarty->assign([
            'adminLink' => $adminLink,
            'current_index' => $this->context->link->getAdminLink('AdminModules', true) . '&configure=' . $this->name
        ]);

        // Variable to store the content to return at the end
        $content = '';

        if ($_POST["submitStoreConf"]) {
            $this->_postProcess();
        }

      /*  if ($_POST['submitnamesearch']) {
            $this->context->smarty->assign('customers', $this->getCustomers());
            $content = $this->fetch('module:' . $this->name . '/views/templates/sms_maziki.tpl');
        }*/

        if (isset($_POST['sendmasssms'])) {
            $selectedCustomers = $_POST['selected_customers'];

        }

        if ($_GET["smstab"] == "test") {
            $content = $this->fetch('module:' . $this->name . '/views/templates/sms_test.tpl');
        }

        if ($_GET["smstab"] == "configure" || !isset($_GET["smstab"])) {
            $this->getcredentials();
            $content = $this->fetch('module:' . $this->name . '/views/templates/sms_configure.tpl');
        }

        if ($_POST['savecreds']) {
            $this->save_credentials();
            $this->getcredentials();
            $content = $this->fetch('module:' . $this->name . '/views/templates/sms_configure.tpl');
        }

        if ($_GET["smstab"] == "sendsms") {
            $resp = $this->sendsms();
            $this->context->smarty->assign('response', $resp);
            $content = $this->fetch('module:' . $this->name . '/views/templates/sms_test.tpl');
        }

        if ($_GET["smstab"] == "protypa") {
            $this->context->smarty->assign('lang_array', $this->getLangs());
            $this->context->smarty->assign('smsarray', $this->getTemplates());
            $content = $this->fetch('module:' . $this->name . '/views/templates/sms_protypa.tpl');
        }

        if ($_GET["smstab"] == "katastaseis") {
            $this->context->smarty->assign('states', $this->getOrderStates());
            $this->context->smarty->assign('smsarray', $this->getTemplates());
            $content = $this->fetch('module:' . $this->name . '/views/templates/sms_katastaseis.tpl');
        }

        if ($_GET["smstab"] == "maziki") {
            
            $paginationData = $this->getCustomers();
			$this->context->smarty->assign('specificsearch', $_GET['specificsearch']);
            $this->context->smarty->assign('smsarray', $this->getSMSTemplatesAll());
            $this->context->smarty->assign('customers', $paginationData['customers']);
            $this->context->smarty->assign('totalPages', $paginationData['totalPages']);
            $this->context->smarty->assign('currentPage', $paginationData['currentPage']);
            $this->context->smarty->assign('prevPageUrl', $paginationData['prevPageUrl']);
            $this->context->smarty->assign('nextPageUrl', $paginationData['nextPageUrl']);
            $this->context->smarty->assign('paginationUrls', $paginationData['paginationUrls']);
            $content = $this->fetch('module:' . $this->name . '/views/templates/sms_maziki.tpl');
        }

        if ($_POST["updatesms"]) {
            $this->updateSms();
            $this->context->smarty->assign('lang_array', $this->getLangs());
            $this->context->smarty->assign('smsarray', $this->getTemplates());
            $content = $this->fetch('module:' . $this->name . '/views/templates/sms_protypa.tpl');
        }

        if ($_POST["deletesms"]) {
            $this->deleteSms();
            $this->context->smarty->assign('lang_array', $this->getLangs());
            $this->context->smarty->assign('smsarray', $this->getTemplates());
            $content = $this->fetch('module:' . $this->name . '/views/templates/sms_protypa.tpl');
        }

        if ($_POST["deleterule"]) {
            $this->deleteRule();
            $this->context->smarty->assign('rule_array', $this->getRules());
            $active = Db::getInstance()->getValue("select active from modulus_time_rule");
            $this->context->smarty->assign('activerule', $active);
            $content = $this->fetch('module:' . $this->name . '/views/templates/sms_xronos.tpl');
        }

        if ($_POST["insertsms"]) {
            $this->insertSms();
            $this->context->smarty->assign('lang_array', $this->getLangs());
            $this->context->smarty->assign('smsarray', $this->getTemplates());
            $content = $this->fetch('module:' . $this->name . '/views/templates/sms_protypa.tpl');
        }

        if ($_POST['sendAllMessages']) {
            $this->sendAllMessages();
        }

        if ($_GET["smstab"] == "xronos") {
            $this->context->smarty->assign('rule_array', $this->getRules());
            $active = Db::getInstance()->getValue("select active from modulus_time_rule");
            $existrule = Db::getInstance()->getValue("select id_rule from modulus_time_rule WHERE id_rule=1");

            if (empty($existrule)) {
                $exists_rule = false;
                $id_rule = '';
            } else {
                $exists_rule = true;
                $id_rule = $existrule;
            }

            $this->context->smarty->assign('activerule', $active);
            $this->context->smarty->assign('exists_rule', $exists_rule);
            $this->context->smarty->assign('id_rule', $id_rule);
            $this->context->smarty->assign('get_time_rules', $this->get_time_rules());
            $content = $this->fetch('module:' . $this->name . '/views/templates/sms_xronos.tpl');
        }


        if (isset($_POST['changeactiverule'])) {

            $active = Tools::getValue("active");
            if ($active == 0) {
                Db::getInstance()->execute("update modulus_time_rule set active = 0");
            } elseif ($active == 1) {
                Db::getInstance()->execute("update modulus_time_rule set active = 1");
            }

            $existrule = Db::getInstance()->getValue("select id_rule from modulus_time_rule WHERE id_rule=1");

            if (empty($existrule)) {
                $exists_rule = false;
                $id_rule = '';

            } else {
                $exists_rule = true;
                $id_rule = $existrule;
            }


            $this->context->smarty->assign('rule_array', $this->getRules());
            $active = Db::getInstance()->getValue("select active from modulus_time_rule");
            $this->context->smarty->assign('activerule', $active);


            $this->context->smarty->assign('exists_rule', $exists_rule);
            $this->context->smarty->assign('id_rule', $id_rule);
            $this->context->smarty->assign('get_time_rules', $this->get_time_rules());
            return $this->fetch('module:' . $this->name . '/views/templates/sms_xronos.tpl');
        }

        $this->getcredentials();
        // Finally return the content
        return $content;
        // return $this->fetch('module:' . $this->name . '/views/templates/sms_configure.tpl');

    }

    public function renderForm()
    {
        $fields_form = array(
            'form' => array(
                'legend' => array(
                    'title' => $this->trans('Ρυθμίσεις για apifon', array(), 'Admin.Global'),
                    'icon' => 'icon-cogs'
                ),
                'input' => array(
                    array(
                        'type' => 'text',
                        'label' => $this->trans('Sender id', array(), 'Modules.SynSmsnotifications.Admin'),
                        'name' => 'SYN_SMS_NOTIFICATIONS_SENDER_ID',
                    ),
                    array(
                        'type' => 'text',
                        'label' => $this->trans('API Token', array(), 'Modules.SynSmsnotifications.Admin'),
                        'name' => 'SYN_SMS_NOTIFICATIONS_API_TOKEN',
                    ),
                    array(
                        'type' => 'text',
                        'label' => $this->trans('API Secret', array(), 'Modules.SynSmsnotifications.Admin'),
                        'name' => 'SYN_SMS_NOTIFICATIONS_API_SECRET',
                    )

                ),
                'submit' => array(
                    'title' => $this->trans('Save', array(), 'Admin.Actions')
                )
            ),
        );

        $lang = new Language((int)Configuration::get('PS_LANG_DEFAULT'));

        $helper = new HelperForm();
        $helper->show_toolbar = false;
        $helper->table = $this->table;
        $helper->default_form_language = $lang->id;
        $helper->module = $this;
        $helper->allow_employee_form_lang = Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG') ? Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG') : 0;
        $helper->identifier = $this->identifier;
        $helper->submit_action = 'submitStoreConf';
        $helper->currentIndex = $this->context->link->getAdminLink('AdminModules', false) . '&configure=' . $this->name . '&tab_module=' . $this->tab . '&module_name=' . $this->name;
        $helper->token = Tools::getAdminTokenLite('AdminModules');
        $helper->tpl_vars = array(
            'uri' => $this->getPathUri(),
            'fields_value' => $this->getConfigFieldsValues(),
            'languages' => $this->context->controller->getLanguages(),
            'id_language' => $this->context->language->id
        );

        return $helper->generateForm(array($fields_form));
    }

    private function _displayForm()
    {
        $domain = Tools::getShopDomain(true);
        if (Tools::usingSecureMode())
            $domain = Tools::getShopDomainSsl(true);

        $this->_html .=
            '<form action="' . Tools::htmlentitiesUTF8($_SERVER['REQUEST_URI']) . '" method="post">
					<input name="sendAllMessages" class="button" type="submit"
					value="' . $this->l('sendAllMessages') . '" />
				</form><br />' .
            '<h2>' . $this->l('Cron job url sendAllTimedMessages') . '</h2><p>' .
            '<b>' . $domain . __PS_BASE_URI__ . 'modules/SynSmsnotifications/SynSmsnotifications-sendAllTimedMessages-cron.php?token=' . substr(Tools::encrypt('SynSmsnotifications/cron'), 0, 10) . '</b></p>';
    }

    public function _postProcess()
    {
        Configuration::updateValue("SYN_SMS_NOTIFICATIONS_SENDER_ID", Tools::getValue("SYN_SMS_NOTIFICATIONS_SENDER_ID"));
        Configuration::updateValue("SYN_SMS_NOTIFICATIONS_API_TOKEN", Tools::getValue("SYN_SMS_NOTIFICATIONS_API_TOKEN"));
        Configuration::updateValue("SYN_SMS_NOTIFICATIONS_API_SECRET", Tools::getValue("SYN_SMS_NOTIFICATIONS_API_SECRET"));
    }

    public function getConfigFieldsValues()
    {
        $fields = array();

        $fields["SYN_SMS_NOTIFICATIONS_SENDER_ID"] = Configuration::get("SYN_SMS_NOTIFICATIONS_SENDER_ID");
        $fields["SYN_SMS_NOTIFICATIONS_API_TOKEN"] = Configuration::get("SYN_SMS_NOTIFICATIONS_API_TOKEN");
        $fields["SYN_SMS_NOTIFICATIONS_API_SECRET"] = Configuration::get("SYN_SMS_NOTIFICATIONS_API_SECRET");

        return $fields;
    }
}
